/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.input;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class DeltaTimeUtils {
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    public static long getMillisFromTimestamp(long microSecsSinceEpochUTC) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(microSecsSinceEpochUTC / 1000000L, (int)(1000L * microSecsSinceEpochUTC % 1000000L), ZoneOffset.UTC);
        return dateTime.atZone(ZONE_ID).toInstant().toEpochMilli();
    }

    public static long getSecondsFromDate(int daysSinceEpochUTC) {
        return LocalDate.ofEpochDay(daysSinceEpochUTC).atStartOfDay(ZONE_ID).toEpochSecond();
    }
}

