/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.input;

import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.delta.input.DeltaInputRow;

public class DeltaInputSourceReader
implements InputSourceReader {
    private final Iterator<CloseableIterator<FilteredColumnarBatch>> filteredColumnarBatchIterators;
    private final InputRowSchema inputRowSchema;

    public DeltaInputSourceReader(Iterator<CloseableIterator<FilteredColumnarBatch>> filteredColumnarBatchIterators, InputRowSchema inputRowSchema) {
        this.filteredColumnarBatchIterators = filteredColumnarBatchIterators;
        this.inputRowSchema = inputRowSchema;
    }

    public org.apache.druid.java.util.common.parsers.CloseableIterator<InputRow> read() {
        return new DeltaInputSourceIterator(this.filteredColumnarBatchIterators, this.inputRowSchema);
    }

    public org.apache.druid.java.util.common.parsers.CloseableIterator<InputRow> read(InputStats inputStats) {
        return new DeltaInputSourceIterator(this.filteredColumnarBatchIterators, this.inputRowSchema);
    }

    public org.apache.druid.java.util.common.parsers.CloseableIterator<InputRowListPlusRawValues> sample() {
        final org.apache.druid.java.util.common.parsers.CloseableIterator<InputRow> inner = this.read();
        return new org.apache.druid.java.util.common.parsers.CloseableIterator<InputRowListPlusRawValues>(){

            public void close() throws IOException {
                inner.close();
            }

            public boolean hasNext() {
                return inner.hasNext();
            }

            public InputRowListPlusRawValues next() {
                DeltaInputRow deltaInputRow = (DeltaInputRow)inner.next();
                return InputRowListPlusRawValues.of((InputRow)deltaInputRow, deltaInputRow.getRawRowAsMap());
            }
        };
    }

    private static class DeltaInputSourceIterator
    implements org.apache.druid.java.util.common.parsers.CloseableIterator<InputRow> {
        private final Iterator<CloseableIterator<FilteredColumnarBatch>> filteredColumnarBatchIterators;
        private CloseableIterator<Row> currentBatch = null;
        private final InputRowSchema inputRowSchema;

        public DeltaInputSourceIterator(Iterator<CloseableIterator<FilteredColumnarBatch>> filteredColumnarBatchCloseableIterator, InputRowSchema inputRowSchema) {
            this.filteredColumnarBatchIterators = filteredColumnarBatchCloseableIterator;
            this.inputRowSchema = inputRowSchema;
        }

        public boolean hasNext() {
            while (this.currentBatch == null || !this.currentBatch.hasNext()) {
                if (!this.filteredColumnarBatchIterators.hasNext()) {
                    return false;
                }
                CloseableIterator<FilteredColumnarBatch> filteredBatchIterator = this.filteredColumnarBatchIterators.next();
                while (filteredBatchIterator.hasNext()) {
                    FilteredColumnarBatch nextBatch = (FilteredColumnarBatch)filteredBatchIterator.next();
                    this.currentBatch = nextBatch.getRows();
                    if (!this.currentBatch.hasNext()) continue;
                    return true;
                }
            }
            return true;
        }

        public InputRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row dataRow = (Row)this.currentBatch.next();
            return new DeltaInputRow(dataRow, this.inputRowSchema);
        }

        public void close() throws IOException {
            if (this.currentBatch != null) {
                this.currentBatch.close();
            }
            if (this.filteredColumnarBatchIterators.hasNext()) {
                this.filteredColumnarBatchIterators.next().close();
            }
        }
    }
}

