/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.input;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.delta.input.DeltaTimeUtils;
import org.apache.druid.delta.input.RowSerde;
import org.apache.druid.error.InvalidInput;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DeltaInputRow
implements InputRow {
    private final Row row;
    private final StructType schema;
    private final Object2IntMap<String> fieldNameToOrdinal = new Object2IntOpenHashMap();
    private final InputRow delegateRow;

    public DeltaInputRow(Row row, InputRowSchema inputRowSchema) {
        this.row = row;
        this.schema = row.getSchema();
        List fieldNames = this.schema.fieldNames();
        for (int i = 0; i < fieldNames.size(); ++i) {
            this.fieldNameToOrdinal.put((Object)((String)fieldNames.get(i)), i);
        }
        this.fieldNameToOrdinal.defaultReturnValue(-1);
        HashMap<String, Object> theMap = new HashMap<String, Object>();
        for (String fieldName : fieldNames) {
            theMap.put(fieldName, this._getRaw(fieldName));
        }
        this.delegateRow = MapInputRowParser.parse((InputRowSchema)inputRowSchema, theMap);
    }

    public List<String> getDimensions() {
        return this.delegateRow.getDimensions();
    }

    public long getTimestampFromEpoch() {
        return this.delegateRow.getTimestampFromEpoch();
    }

    public DateTime getTimestamp() {
        return this.delegateRow.getTimestamp();
    }

    public List<String> getDimension(String dimension) {
        return this.delegateRow.getDimension(dimension);
    }

    @Nullable
    public Object getRaw(String dimension) {
        return this.delegateRow.getRaw(dimension);
    }

    @Nullable
    public Number getMetric(String metric) {
        return this.delegateRow.getMetric(metric);
    }

    public int compareTo(org.apache.druid.data.input.Row o) {
        return this.getTimestamp().compareTo((ReadableInstant)o.getTimestamp());
    }

    public boolean equals(Object o) {
        return o instanceof DeltaInputRow && this.compareTo((org.apache.druid.data.input.Row)((DeltaInputRow)o)) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.row, this.schema, this.fieldNameToOrdinal, this.delegateRow);
    }

    public String toString() {
        return "DeltaInputRow{row=" + String.valueOf(this.row) + ", schema=" + String.valueOf(this.schema) + ", fieldNameToOrdinal=" + String.valueOf(this.fieldNameToOrdinal) + ", delegateRow=" + String.valueOf(this.delegateRow) + "}";
    }

    public Map<String, Object> getRawRowAsMap() {
        return RowSerde.convertRowToJsonObject(this.row);
    }

    @Nullable
    private Object _getRaw(String dimension) {
        StructField field = this.schema.get(dimension);
        if (field == null || field.isMetadataColumn()) {
            return null;
        }
        int ordinal = this.fieldNameToOrdinal.getInt((Object)dimension);
        if (ordinal < 0) {
            return null;
        }
        return DeltaInputRow.getValue(field.getDataType(), this.row, ordinal);
    }

    @Nullable
    private static Object getValue(DataType dataType, Row dataRow, int columnOrdinal) {
        if (dataRow.isNullAt(columnOrdinal)) {
            return null;
        }
        if (dataType instanceof BooleanType) {
            return dataRow.getBoolean(columnOrdinal);
        }
        if (dataType instanceof ByteType) {
            return dataRow.getByte(columnOrdinal);
        }
        if (dataType instanceof ShortType) {
            return dataRow.getShort(columnOrdinal);
        }
        if (dataType instanceof IntegerType) {
            return dataRow.getInt(columnOrdinal);
        }
        if (dataType instanceof DateType) {
            return DeltaTimeUtils.getSecondsFromDate(dataRow.getInt(columnOrdinal));
        }
        if (dataType instanceof LongType) {
            return dataRow.getLong(columnOrdinal);
        }
        if (dataType instanceof TimestampType) {
            return DeltaTimeUtils.getMillisFromTimestamp(dataRow.getLong(columnOrdinal));
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(dataRow.getFloat(columnOrdinal));
        }
        if (dataType instanceof DoubleType) {
            return dataRow.getDouble(columnOrdinal);
        }
        if (dataType instanceof StringType) {
            return dataRow.getString(columnOrdinal);
        }
        if (dataType instanceof BinaryType) {
            byte[] arr = dataRow.getBinary(columnOrdinal);
            char[] charArray = new char[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                charArray[i] = (char)arr[i];
            }
            return String.valueOf(charArray);
        }
        if (dataType instanceof DecimalType) {
            return dataRow.getDecimal(columnOrdinal);
        }
        if (dataType instanceof StructType) {
            Row structRow = dataRow.getStruct(columnOrdinal);
            return RowSerde.convertRowToJsonObject(structRow);
        }
        if (dataType instanceof ArrayType) {
            ArrayValue arrayRow = dataRow.getArray(columnOrdinal);
            return VectorUtils.toJavaList((ArrayValue)arrayRow);
        }
        if (dataType instanceof MapType) {
            MapValue map = dataRow.getMap(columnOrdinal);
            return VectorUtils.toJavaMap((MapValue)map);
        }
        throw InvalidInput.exception((String)"Unsupported data type[%s] for fieldName[%s].", (Object[])new Object[]{dataType, dataRow.getSchema().fieldNames().get(columnOrdinal)});
    }
}

