/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.types.StructType;
import java.util.List;
import org.apache.druid.delta.filter.DeltaFilter;
import org.apache.druid.delta.filter.DeltaFilterUtils;
import org.apache.druid.error.InvalidInput;

public class DeltaLessThanOrEqualsFilter
implements DeltaFilter {
    @JsonProperty
    private final String column;
    @JsonProperty
    private final String value;

    @JsonCreator
    public DeltaLessThanOrEqualsFilter(@JsonProperty(value="column") String column, @JsonProperty(value="value") String value) {
        if (column == null) {
            throw InvalidInput.exception((String)"column is a required field for <= filter.", (Object[])new Object[0]);
        }
        if (value == null) {
            throw InvalidInput.exception((String)"value is a required field for <= filter. None provided for column[%s].", (Object[])new Object[]{column});
        }
        this.column = column;
        this.value = value;
    }

    @Override
    public Predicate getFilterPredicate(StructType snapshotSchema) {
        return new Predicate("<=", (List)ImmutableList.of((Object)new Column(this.column), (Object)DeltaFilterUtils.dataTypeToLiteral(snapshotSchema, this.column, this.value)));
    }
}

