/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.filter;

import io.delta.kernel.expressions.Literal;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.apache.druid.error.InvalidInput;

public class DeltaFilterUtils {
    static Literal dataTypeToLiteral(StructType snapshotSchema, String column, String value) {
        if (!snapshotSchema.fieldNames().contains(column)) {
            throw InvalidInput.exception((String)"column[%s] doesn't exist in schema[%s]", (Object[])new Object[]{column, snapshotSchema});
        }
        StructField structField = snapshotSchema.get(column);
        DataType dataType = structField.getDataType();
        try {
            if (dataType instanceof StringType) {
                return Literal.ofString((String)value);
            }
            if (dataType instanceof IntegerType) {
                return Literal.ofInt((int)Integer.parseInt(value));
            }
            if (dataType instanceof ShortType) {
                return Literal.ofShort((short)Short.parseShort(value));
            }
            if (dataType instanceof LongType) {
                return Literal.ofLong((long)Long.parseLong(value));
            }
            if (dataType instanceof FloatType) {
                return Literal.ofFloat((float)Float.parseFloat(value));
            }
            if (dataType instanceof DoubleType) {
                return Literal.ofDouble((double)Double.parseDouble(value));
            }
            if (dataType instanceof DateType) {
                Date dataVal = Date.valueOf(value);
                int daysSinceEpoch = (int)ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), dataVal.toLocalDate());
                return Literal.ofDate((int)daysSinceEpoch);
            }
            throw InvalidInput.exception((String)"Unsupported data type[%s] for column[%s] with value[%s].", (Object[])new Object[]{dataType, column, value});
        }
        catch (NumberFormatException e) {
            throw InvalidInput.exception((String)"column[%s] has an invalid value[%s]. The value must be a number, as the column's data type is [%s].", (Object[])new Object[]{column, value, dataType});
        }
    }
}

