/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.types.StructType;
import java.util.List;
import org.apache.druid.delta.filter.DeltaFilter;
import org.apache.druid.error.InvalidInput;

public class DeltaAndFilter
implements DeltaFilter {
    @JsonProperty
    private final List<DeltaFilter> filters;

    @JsonCreator
    public DeltaAndFilter(@JsonProperty(value="filters") List<DeltaFilter> filters) {
        if (filters == null) {
            throw InvalidInput.exception((String)"Delta and filter requires 2 filter predicates and must be non-empty. None provided.", (Object[])new Object[0]);
        }
        if (filters.size() != 2) {
            throw InvalidInput.exception((String)"Delta and filter requires 2 filter predicates, but provided [%d].", (Object[])new Object[]{filters.size()});
        }
        this.filters = filters;
    }

    @Override
    public Predicate getFilterPredicate(StructType snapshotSchema) {
        return new And(this.filters.get(0).getFilterPredicate(snapshotSchema), this.filters.get(1).getFilterPredicate(snapshotSchema));
    }
}

