/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.delta.common;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import java.util.Collections;
import java.util.List;
import org.apache.druid.delta.input.DeltaInputSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.initialization.DruidModule;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class DeltaLakeDruidModule
implements DruidModule {
    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("DeltaLakeDruidModule").registerSubtypes(new NamedType[]{new NamedType(DeltaInputSource.class, "delta")}));
    }

    public void configure(Binder binder) {
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        ClassLoader currCtxCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FileSystem.get((Configuration)conf);
        }
        catch (Exception ex) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)ex, "Problem during fileSystem class level initialization", new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currCtxCl);
        }
    }
}

