/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketchProtoBinding;
import com.datadoghq.sketch.ddsketch.proto.DDSketch;
import com.datadoghq.sketch.ddsketch.store.CollapsingLowestDenseStore;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.ddsketch.DDSketchAggregatorFactory;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class DDSketchUtils {
    private DDSketchUtils() {
    }

    public static com.datadoghq.sketch.ddsketch.DDSketch deserialize(Object serializedSketch) {
        try {
            if (serializedSketch instanceof String) {
                String str = (String)serializedSketch;
                byte[] bytes = StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)str));
                DDSketch proto = DDSketch.parseFrom((byte[])bytes);
                com.datadoghq.sketch.ddsketch.DDSketch recovered = DDSketchProtoBinding.fromProto(() -> new CollapsingLowestDenseStore(1000), (DDSketch)proto);
                return recovered;
            }
            if (serializedSketch instanceof byte[]) {
                DDSketch proto = DDSketch.parseFrom((byte[])((byte[])serializedSketch));
                com.datadoghq.sketch.ddsketch.DDSketch recovered = DDSketchProtoBinding.fromProto(() -> new CollapsingLowestDenseStore(1000), (DDSketch)proto);
                return recovered;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IAE("Object cannot be deserialized to a DDSketch Sketch: " + serializedSketch.getClass(), new Object[0]);
        }
        if (serializedSketch instanceof com.datadoghq.sketch.ddsketch.DDSketch) {
            return (com.datadoghq.sketch.ddsketch.DDSketch)serializedSketch;
        }
        throw new IAE("Object cannot be deserialized to a DDSketch Sketch: " + serializedSketch.getClass(), new Object[0]);
    }

    static byte[] toBytes(com.datadoghq.sketch.ddsketch.DDSketch sketch) {
        return DDSketchProtoBinding.toProto((com.datadoghq.sketch.ddsketch.DDSketch)sketch).toByteArray();
    }

    public static boolean matchingAggregatorFactoryExists(VirtualColumnRegistry virtualColumnRegistry, DruidExpression input, double relativeError, int numBins, DDSketchAggregatorFactory factory) {
        DruidExpression virtualInput = virtualColumnRegistry.findVirtualColumnExpressions(factory.requiredFields()).stream().findFirst().orElse(null);
        boolean inputMatches = virtualInput == null ? input.isDirectColumnAccess() && input.getDirectColumn().equals(factory.getFieldName()) : virtualInput.equals((Object)input);
        return inputMatches && relativeError == factory.getRelativeError() && numBins == factory.getNumBins();
    }
}

