/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class DDSketchToQuantilesPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final double[] fractions;
    public static final String TYPE_NAME = "quantilesFromDDSketch";

    @JsonCreator
    public DDSketchToQuantilesPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="fractions") double[] fractions) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.fractions = (double[])Preconditions.checkNotNull((Object)fractions, (Object)"array of fractions is null");
        Preconditions.checkArgument((this.fractions.length >= 1 ? 1 : 0) != 0, (Object)"Array of fractions cannot be empty");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE_ARRAY;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public double[] getFractions() {
        return this.fractions;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        DDSketch sketch = (DDSketch)this.field.compute(combinedAggregators);
        if (sketch == null || sketch.getCount() == 0.0) {
            return Double.NaN;
        }
        double[] quantiles = new double[this.fractions.length];
        int i = 0;
        for (double f : this.fractions) {
            quantiles[i++] = sketch.getValueAtQuantile(f);
        }
        return quantiles;
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing arrays of quantiles is not supported", new Object[0]);
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', field=" + this.field + ", fractions=" + Arrays.toString(this.fractions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDSketchToQuantilesPostAggregator that = (DDSketchToQuantilesPostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.fractions, that.fractions)) {
            return false;
        }
        return this.field.equals(that.field);
    }

    public int hashCode() {
        return (this.name.hashCode() * 31 + this.field.hashCode()) * 31 + Arrays.hashCode(this.fractions);
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(51).appendCacheable((Cacheable)this.field);
        for (double value : this.fractions) {
            builder.appendDouble(value);
        }
        return builder.build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

