/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class DDSketchToQuantilePostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;
    private final double fraction;
    public static final String TYPE_NAME = "quantileFromDDSketch";
    private static final EmittingLogger log = new EmittingLogger(DDSketchToQuantilePostAggregator.class);

    @JsonCreator
    public DDSketchToQuantilePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="fraction") double fraction) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.fraction = fraction;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    public double getFraction() {
        return this.fraction;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        DDSketch sketch = (DDSketch)this.field.compute(combinedAggregators);
        if (sketch == null || sketch.getCount() == 0.0) {
            return Double.NaN;
        }
        return sketch.getValueAtQuantile(this.fraction);
    }

    public Comparator<Double> getComparator() {
        return Doubles::compare;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', field=" + this.field + ", fraction=" + this.fraction + "}";
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(52).appendCacheable((Cacheable)this.field);
        builder.appendDouble(this.fraction);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDSketchToQuantilePostAggregator that = (DDSketchToQuantilePostAggregator)o;
        return Double.compare(that.fraction, this.fraction) == 0 && Objects.equals(this.name, that.name) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field, this.fraction);
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

