/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.ddsketch.DDSketchObjectStrategy;
import org.apache.druid.query.aggregation.ddsketch.DDSketchUtils;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class DDSketchComplexMetricSerde
extends ComplexMetricSerde {
    private static final DDSketchObjectStrategy STRATEGY = new DDSketchObjectStrategy();

    public String getTypeName() {
        return "ddSketch";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<?> extractedClass() {
                return DDSketch.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object obj = inputRow.getRaw(metricName);
                if (obj == null || obj instanceof Number || obj instanceof DDSketch) {
                    return obj;
                }
                if (obj instanceof String) {
                    String objString = (String)obj;
                    if (objString.isEmpty()) {
                        return null;
                    }
                    try {
                        Double doubleValue = Double.parseDouble(objString);
                        return doubleValue;
                    }
                    catch (NumberFormatException e) {
                        throw new IAE("Expected string with a number, received value: " + objString, new Object[0]);
                    }
                }
                return DDSketchUtils.deserialize(obj);
            }
        };
    }

    public ObjectStrategy<DDSketch> getObjectStrategy() {
        return STRATEGY;
    }
}

