/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.datadoghq.sketch.ddsketch.DDSketches;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.ColumnValueSelector;

public class DDSketchBufferAggregator
implements BufferAggregator {
    @Nonnull
    private final ColumnValueSelector selector;
    private final double relativeError;
    private final int numBins;
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<DDSketch>> sketchCache = new IdentityHashMap();

    public DDSketchBufferAggregator(ColumnValueSelector valueSelector, double relativeError, int numBins) {
        Preconditions.checkNotNull((Object)valueSelector);
        this.selector = valueSelector;
        this.relativeError = relativeError;
        this.numBins = numBins;
    }

    public void init(ByteBuffer buffer, int position) {
        DDSketch sketch = DDSketches.collapsingLowestDense((double)this.relativeError, (int)this.numBins);
        ByteBuffer mutationBuffer = buffer.duplicate();
        mutationBuffer.position(position);
        this.addToCache(buffer, position, sketch);
    }

    public void aggregate(ByteBuffer buffer, int position) {
        Object x = this.selector.getObject();
        if (x == null) {
            return;
        }
        DDSketch sketch = (DDSketch)this.sketchCache.get(buffer).get(position);
        if (x instanceof Number) {
            sketch.accept(((Number)x).doubleValue());
        } else if (x instanceof DDSketch) {
            sketch.mergeWith((DDSketch)x);
        } else {
            throw new IAE("Expected a number or an instance of DDSketch, but received [%s] of type [%s]", new Object[]{x, x.getClass()});
        }
    }

    public Object get(ByteBuffer buffer, int position) {
        DDSketch obj = (DDSketch)this.sketchCache.get(buffer).get(position);
        return obj;
    }

    public float getFloat(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.sketchCache.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        DDSketch sketch = (DDSketch)this.sketchCache.get(oldBuffer).get(oldPosition);
        this.addToCache(newBuffer, newPosition, sketch);
        Int2ObjectMap<DDSketch> map = this.sketchCache.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.sketchCache.remove(oldBuffer);
        }
    }

    private void addToCache(ByteBuffer buffer, int position, DDSketch sketch) {
        Int2ObjectMap map = this.sketchCache.computeIfAbsent(buffer, b -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)sketch);
    }
}

