/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.datadoghq.sketch.ddsketch.DDSketches;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.math.IntMath;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.ddsketch.DDSketchAggregator;
import org.apache.druid.query.aggregation.ddsketch.DDSketchBufferAggregator;
import org.apache.druid.query.aggregation.ddsketch.DDSketchUtils;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="ddSketch")
public class DDSketchAggregatorFactory
extends AggregatorFactory {
    public static final double DEFAULT_RELATIVE_ERROR = 0.01;
    public static final int DEFAULT_NUM_BINS = 1000;
    @Nonnull
    private final String name;
    @Nonnull
    private final String fieldName;
    private final double relativeError;
    private final int numBins;
    private final byte cacheTypeId;
    public static final String TYPE_NAME = "ddSketch";
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"ddSketch");
    public static final Comparator<DDSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(a -> a.serializedSize()));

    @JsonCreator
    public DDSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="relativeError") Double relativeError, @JsonProperty(value="numBins") Integer numBins) {
        this(name, fieldName, relativeError, numBins, 80);
    }

    DDSketchAggregatorFactory(String name, String fieldName, @Nullable Double relativeError, @Nullable Integer numBins, byte cacheTypeId) {
        this.name = Objects.requireNonNull(name, "Must have a valid, non-null aggregator name");
        this.fieldName = Objects.requireNonNull(fieldName, "Parameter fieldName must be specified");
        this.relativeError = relativeError == null ? 0.01 : relativeError;
        this.numBins = numBins == null ? 1000 : numBins;
        this.cacheTypeId = cacheTypeId;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.cacheTypeId).appendString(this.fieldName).appendDouble(this.relativeError).appendInt(this.numBins).build();
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new DDSketchAggregator(metricFactory.makeColumnValueSelector(this.fieldName), this.relativeError, this.numBins);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new DDSketchBufferAggregator(metricFactory.makeColumnValueSelector(this.fieldName), this.relativeError, this.numBins);
    }

    public Comparator getComparator() {
        return COMPARATOR;
    }

    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        DDSketch union = (DDSketch)lhs;
        union.mergeWith((DDSketch)rhs);
        return union;
    }

    public AggregatorFactory getCombiningFactory() {
        return new DDSketchAggregatorFactory(this.name, this.name, this.relativeError, this.numBins);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && ((Object)((Object)this)).getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DDSketchAggregatorFactory(this.name, this.fieldName, this.relativeError, this.numBins));
    }

    public Object deserialize(Object serializedSketch) {
        return DDSketchUtils.deserialize(serializedSketch);
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : Double.valueOf(((DDSketch)object).getCount());
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public double getRelativeError() {
        return this.relativeError;
    }

    @JsonProperty
    public int getNumBins() {
        return this.numBins;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public ColumnType getIntermediateType() {
        return TYPE;
    }

    public ColumnType getResultType() {
        return TYPE;
    }

    public int getMaxIntermediateSize() {
        return IntMath.checkedMultiply((int)this.numBins, (int)16) + 8 + 8 + 8 + 4 + 12;
    }

    public AggregatorFactory withName(String newName) {
        return new DDSketchAggregatorFactory(newName, this.getFieldName(), this.getRelativeError(), this.getNumBins(), this.cacheTypeId);
    }

    public AggregateCombiner<DDSketch> makeAggregateCombiner() {
        return new ObjectAggregateCombiner<DDSketch>(){
            private DDSketch combined;
            {
                this.combined = DDSketches.collapsingLowestDense((double)DDSketchAggregatorFactory.this.relativeError, (int)DDSketchAggregatorFactory.this.numBins);
            }

            public void reset(ColumnValueSelector selector) {
                this.combined.clear();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                DDSketch other = (DDSketch)selector.getObject();
                if (other == null) {
                    return;
                }
                this.combined.mergeWith(other);
            }

            @Nullable
            public DDSketch getObject() {
                return this.combined;
            }

            public Class<DDSketch> classOfObject() {
                return DDSketch.class;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !((Object)((Object)this)).getClass().equals(o.getClass())) {
            return false;
        }
        DDSketchAggregatorFactory that = (DDSketchAggregatorFactory)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName) && this.relativeError == that.relativeError && this.numBins == that.numBins;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.relativeError, this.numBins);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name=" + this.name + ", fieldName=" + this.fieldName + ", relativeError=" + this.relativeError + ", numBins=" + this.numBins + "}";
    }
}

