/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.ddsketch;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.datadoghq.sketch.ddsketch.DDSketches;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.ColumnValueSelector;

public class DDSketchAggregator
implements Aggregator {
    private final ColumnValueSelector selector;
    @GuardedBy(value="this")
    private DDSketch histogram;

    public DDSketchAggregator(ColumnValueSelector selector, @Nullable Double relativeError, @Nullable Integer numBins) {
        int effectiveNumBins = numBins != null ? numBins : 1000;
        double effectiveRelativeError = relativeError != null ? relativeError : 0.01;
        this.selector = selector;
        this.histogram = DDSketches.collapsingLowestDense((double)effectiveRelativeError, (int)effectiveNumBins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate() {
        Object obj = this.selector.getObject();
        if (obj == null) {
            return;
        }
        DDSketchAggregator dDSketchAggregator = this;
        synchronized (dDSketchAggregator) {
            if (obj instanceof Number) {
                this.histogram.accept(((Number)obj).doubleValue());
            } else if (obj instanceof DDSketch) {
                this.histogram.mergeWith((DDSketch)obj);
            } else {
                throw new IAE("Expected a number or an instance of DDSketch, but received [%s] of type [%s]", new Object[]{obj, obj.getClass()});
            }
        }
    }

    @Nullable
    public synchronized Object get() {
        return this.histogram;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Casting to float type is not supported");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Casting to long type is not supported");
    }

    public synchronized void close() {
        this.histogram = null;
    }
}

