/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal.aggregator.min;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import org.apache.druid.compressedbigdecimal.ArrayCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.aggregator.CompressedBigDecimalAggregatorFactoryBase;
import org.apache.druid.compressedbigdecimal.aggregator.min.CompressedBigDecimalMinAggregateCombiner;
import org.apache.druid.compressedbigdecimal.aggregator.min.CompressedBigDecimalMinAggregator;
import org.apache.druid.compressedbigdecimal.aggregator.min.CompressedBigDecimalMinBufferAggregator;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;

public class CompressedBigDecimalMinAggregatorFactory
extends CompressedBigDecimalAggregatorFactoryBase {
    private static final byte CACHE_TYPE_ID = 56;

    @JsonCreator
    public CompressedBigDecimalMinAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="size", required=false) Integer size, @JsonProperty(value="scale", required=false) Integer scale, @JsonProperty(value="strictNumberParsing", required=false) Boolean strictNumberParsing) {
        super(name, fieldName, size, scale, strictNumberParsing, (byte)56);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory, @Nonnull ColumnValueSelector<CompressedBigDecimal> selector) {
        return new CompressedBigDecimalMinAggregator(this.size, this.scale, selector, this.strictNumberParsing);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, @Nonnull ColumnValueSelector<CompressedBigDecimal> selector) {
        return new CompressedBigDecimalMinBufferAggregator(this.size, this.scale, selector, this.strictNumberParsing);
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (lhs == null && rhs == null) {
            return null;
        }
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        ArrayCompressedBigDecimal retVal = ArrayCompressedBigDecimal.allocateMax(this.size, this.scale);
        CompressedBigDecimal left = (CompressedBigDecimal)lhs;
        CompressedBigDecimal right = (CompressedBigDecimal)rhs;
        retVal.accumulateMin(left);
        retVal.accumulateMin(right);
        return retVal;
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new CompressedBigDecimalMinAggregatorFactory(this.name, this.name, this.size, this.scale, this.strictNumberParsing);
    }

    @Override
    public AggregateCombiner<CompressedBigDecimal> makeAggregateCombiner() {
        return new CompressedBigDecimalMinAggregateCombiner();
    }

    public AggregatorFactory withName(String newName) {
        return new CompressedBigDecimalMinAggregatorFactory(newName, this.fieldName, this.size, this.scale, this.strictNumberParsing);
    }

    @Override
    public String toString() {
        return "CompressedBigDecimalMinAggregatorFactory{name='" + this.getName() + "', type='" + this.getIntermediateType().asTypeString() + "', fieldName='" + this.getFieldName() + "', requiredFields='" + this.requiredFields() + "', size='" + this.getSize() + "', scale='" + this.getScale() + "', strictNumberParsing='" + this.getStrictNumberParsing() + "'}";
    }
}

