/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal.aggregator.min;

import java.nio.ByteBuffer;
import org.apache.druid.compressedbigdecimal.ByteBufferCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.Utils;
import org.apache.druid.compressedbigdecimal.aggregator.CompressedBigDecimalBufferAggregatorBase;
import org.apache.druid.segment.ColumnValueSelector;

public class CompressedBigDecimalMinBufferAggregator
extends CompressedBigDecimalBufferAggregatorBase {
    private static final int HEADER_OFFSET_BYTES = 1;

    public CompressedBigDecimalMinBufferAggregator(int size, int scale, ColumnValueSelector<CompressedBigDecimal> selector, boolean strictNumberParsing) {
        super(size, scale, selector, strictNumberParsing, 1);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBufferCompressedBigDecimal.initMax(buf, position + 1, this.size);
        this.setEmpty(true, buf, position);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        CompressedBigDecimal addend = Utils.objToCompressedBigDecimalWithScale(this.selector.getObject(), this.scale, this.strictNumberParsing);
        if (addend != null) {
            this.setEmpty(false, buf, position);
            ByteBufferCompressedBigDecimal existing = new ByteBufferCompressedBigDecimal(buf, position + 1, this.size, this.scale);
            existing.accumulateMin(addend);
        }
    }
}

