/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal.aggregator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.Utils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NullableNumericAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

public abstract class CompressedBigDecimalAggregatorFactoryBase
extends NullableNumericAggregatorFactory<ColumnValueSelector<CompressedBigDecimal>> {
    public static final int DEFAULT_SCALE = 9;
    public static final int DEFAULT_SIZE = 6;
    public static final boolean DEFAULT_STRICT_NUMBER_PARSING = false;
    public static final int BUFFER_AGGREGATOR_HEADER_SIZE_BYTES = 1;
    public static final Comparator<CompressedBigDecimal> COMPARATOR = CompressedBigDecimal::compareTo;
    protected final String name;
    protected final String fieldName;
    protected final int size;
    protected final int scale;
    protected final boolean strictNumberParsing;
    private final byte[] cacheKey;

    protected CompressedBigDecimalAggregatorFactoryBase(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="size", required=false) Integer size, @JsonProperty(value="scale", required=false) Integer scale, @JsonProperty(value="strictNumberParsing", required=false) Boolean strictNumberParsing, byte cacheTypeId) {
        this.name = name;
        this.fieldName = fieldName;
        this.size = size == null ? 6 : size;
        this.scale = scale == null ? 9 : scale;
        this.strictNumberParsing = strictNumberParsing == null ? false : strictNumberParsing;
        byte[] fieldNameBytes = StringUtils.toUtf8((String)fieldName);
        this.cacheKey = ByteBuffer.allocate(1 + fieldNameBytes.length + 8 + 1).put(cacheTypeId).put(fieldNameBytes).putInt(this.size).putInt(this.scale).put((byte)(this.strictNumberParsing ? 1 : 0)).array();
    }

    public ColumnValueSelector<CompressedBigDecimal> selector(ColumnSelectorFactory metricFactory) {
        return metricFactory.makeColumnValueSelector(this.fieldName);
    }

    protected abstract Aggregator factorize(ColumnSelectorFactory var1, ColumnValueSelector<CompressedBigDecimal> var2);

    protected abstract BufferAggregator factorizeBuffered(ColumnSelectorFactory var1, ColumnValueSelector<CompressedBigDecimal> var2);

    public Comparator<CompressedBigDecimal> getComparator() {
        return COMPARATOR;
    }

    @Nullable
    public abstract Object combine(Object var1, Object var2);

    public abstract AggregatorFactory getCombiningFactory();

    public abstract AggregateCombiner<CompressedBigDecimal> makeAggregateCombiner();

    public abstract String toString();

    @Nullable
    public Object deserialize(Object object) {
        return Utils.objToCompressedBigDecimal(object);
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public ColumnType getIntermediateType() {
        return ColumnType.ofComplex((String)"compressedBigDecimal");
    }

    public byte[] getCacheKey() {
        return this.cacheKey;
    }

    public Object finalizeComputation(Object object) {
        return object;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getScale() {
        return this.scale;
    }

    @JsonProperty
    public int getSize() {
        return this.size;
    }

    @JsonProperty
    public boolean getStrictNumberParsing() {
        return this.strictNumberParsing;
    }

    public int getMaxIntermediateSize() {
        return 1 + 4 * this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompressedBigDecimalAggregatorFactoryBase that = (CompressedBigDecimalAggregatorFactoryBase)((Object)o);
        return this.size == that.size && this.scale == that.scale && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.fieldName, (Object)that.fieldName) && Objects.equal((Object)this.strictNumberParsing, (Object)that.strictNumberParsing);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.fieldName, this.size, this.scale, this.strictNumberParsing});
    }
}

