/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import java.nio.ByteBuffer;
import org.apache.druid.compressedbigdecimal.ByteBufferCompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.CompressedBigDecimal;
import org.apache.druid.compressedbigdecimal.Utils;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class CompressedBigDecimalBufferAggregatorBase
implements BufferAggregator {
    protected final ColumnValueSelector<CompressedBigDecimal> selector;
    protected final int size;
    protected final int scale;
    protected final boolean strictNumberParsing;
    private final int headerSizeBytes;

    public CompressedBigDecimalBufferAggregatorBase(int size, int scale, ColumnValueSelector<CompressedBigDecimal> selector, boolean strictNumberParsing, int headerSizeBytes) {
        this.selector = selector;
        this.size = size;
        this.scale = scale;
        this.strictNumberParsing = strictNumberParsing;
        this.headerSizeBytes = headerSizeBytes;
    }

    public void init(ByteBuffer buf, int position) {
        ByteBufferCompressedBigDecimal.initMin(buf, position + this.headerSizeBytes, this.size);
        this.setEmpty(true, buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        CompressedBigDecimal addend = Utils.objToCompressedBigDecimalWithScale(this.selector.getObject(), this.scale, this.strictNumberParsing);
        if (addend != null) {
            this.setEmpty(false, buf, position);
            ByteBufferCompressedBigDecimal existing = new ByteBufferCompressedBigDecimal(buf, position + this.headerSizeBytes, this.size, this.scale);
            existing.accumulateMax(addend);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        if (this.isEmpty(buf, position)) {
            return null;
        }
        ByteBufferCompressedBigDecimal byteBufferCompressedBigDecimal = new ByteBufferCompressedBigDecimal(buf, position + this.headerSizeBytes, this.size, this.scale);
        CompressedBigDecimal heapCompressedBigDecimal = byteBufferCompressedBigDecimal.toHeap();
        return heapCompressedBigDecimal;
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support getLong()");
    }

    public void close() {
    }

    protected final void setEmpty(boolean value, ByteBuffer byteBuffer, int position) {
        if (this.headerSizeBytes > 0) {
            byteBuffer.put(position, (byte)(value ? 1 : 0));
        }
    }

    protected final boolean isEmpty(ByteBuffer byteBuffer, int position) {
        if (this.headerSizeBytes > 0) {
            return byteBuffer.get(position) != 0;
        }
        return false;
    }
}

