/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.compressedbigdecimal;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.ToIntBiFunction;
import org.apache.druid.compressedbigdecimal.ObjBiIntConsumer;
import org.apache.druid.java.util.common.IAE;

public abstract class CompressedBigDecimal
extends Number
implements Comparable<CompressedBigDecimal> {
    protected static final long INT_MASK = 0xFFFFFFFFL;
    private final int scale;

    protected CompressedBigDecimal(int scale) {
        this.scale = scale;
    }

    public CompressedBigDecimal accumulateSum(CompressedBigDecimal rhs) {
        this.checkScaleCompatibility(rhs);
        if (rhs.getArraySize() > this.getArraySize()) {
            throw new IllegalArgumentException("Right hand side too big to fit in the result value");
        }
        CompressedBigDecimal.internalAdd(this.getArraySize(), this, CompressedBigDecimal::getArrayEntry, CompressedBigDecimal::setArrayEntry, rhs.getArraySize(), rhs, CompressedBigDecimal::getArrayEntry);
        return this;
    }

    public CompressedBigDecimal accumulateMax(CompressedBigDecimal rhs) {
        this.checkScaleCompatibility(rhs);
        if (this.compareTo(rhs) < 0) {
            this.setValue(rhs);
        }
        return this;
    }

    public CompressedBigDecimal accumulateMin(CompressedBigDecimal rhs) {
        this.checkScaleCompatibility(rhs);
        if (this.compareTo(rhs) > 0) {
            this.setValue(rhs);
        }
        return this;
    }

    private void checkScaleCompatibility(CompressedBigDecimal rhs) {
        Preconditions.checkArgument((rhs.getScale() == this.getScale() ? 1 : 0) != 0, (String)"scales do not match: lhs [%s] vs rhs [%s]", (int)this.getScale(), (int)rhs.getScale());
    }

    protected abstract void setValue(CompressedBigDecimal var1);

    public void reset() {
        for (int ii = 0; ii < this.getArraySize(); ++ii) {
            this.setArrayEntry(ii, 0);
        }
    }

    static <R, S> void internalAdd(int llen, R lhs, ToIntBiFunction<R, Integer> lhsGet, ObjBiIntConsumer<R> lhsSet, int rlen, S rhs, ToIntBiFunction<S, Integer> rhsGet) {
        long sum;
        int commonLen = Integer.min(llen, rlen);
        long carry = 0L;
        for (int ii = 0; ii < commonLen; ++ii) {
            sum = (0xFFFFFFFFL & (long)lhsGet.applyAsInt(lhs, ii)) + (0xFFFFFFFFL & (long)rhsGet.applyAsInt(rhs, ii)) + carry;
            lhsSet.accept(lhs, ii, (int)sum);
            carry = sum >>> 32;
        }
        long signExtension = CompressedBigDecimal.signumInternal(rlen, rhs, rhsGet) < 0 ? 0xFFFFFFFFL : 0L;
        for (int ii = commonLen; ii < llen && (carry != 0L || signExtension != 0L); ++ii) {
            sum = (0xFFFFFFFFL & (long)lhsGet.applyAsInt(lhs, ii)) + signExtension + carry;
            lhsSet.accept(lhs, ii, (int)sum);
            carry = sum >>> 32;
        }
    }

    private ByteArrayResult toByteArray() {
        int byteArrayLength = this.getArraySize() * 4;
        byte[] bytes = new byte[byteArrayLength];
        int byteIdx = 0;
        boolean isZero = true;
        for (int ii = this.getArraySize(); ii > 0; --ii) {
            int val = this.getArrayEntry(ii - 1);
            if (val != 0) {
                isZero = false;
            }
            bytes[byteIdx + 3] = (byte)val;
            bytes[byteIdx + 2] = (byte)(val >>>= 8);
            bytes[byteIdx + 1] = (byte)(val >>>= 8);
            bytes[byteIdx] = (byte)(val >>>= 8);
            byteIdx += 4;
        }
        int leadingZeros = Integer.numberOfLeadingZeros(this.getArrayEntry(this.getArraySize() - 1));
        int emptyBytes = leadingZeros / 8;
        if (emptyBytes != 0) {
            if (emptyBytes == byteArrayLength || leadingZeros % 8 == 0) {
                --emptyBytes;
            }
            return new ByteArrayResult(Arrays.copyOfRange(bytes, emptyBytes, byteArrayLength), isZero);
        }
        return new ByteArrayResult(bytes, isZero);
    }

    protected void setMinValue() {
        for (int i = 0; i < this.getArraySize(); ++i) {
            if (i == this.getArraySize() - 1) {
                this.setArrayEntry(i, Integer.MIN_VALUE);
                continue;
            }
            this.setArrayEntry(i, 0);
        }
    }

    protected void setMaxValue() {
        for (int i = 0; i < this.getArraySize(); ++i) {
            if (i == this.getArraySize() - 1) {
                this.setArrayEntry(i, Integer.MAX_VALUE);
                continue;
            }
            this.setArrayEntry(i, -1);
        }
    }

    public int getScale() {
        return this.scale;
    }

    public abstract CompressedBigDecimal toHeap();

    protected abstract int getArraySize();

    protected abstract int getArrayEntry(int var1);

    protected abstract void setArrayEntry(int var1, int var2);

    public BigDecimal toBigDecimal() {
        ByteArrayResult byteArrayResult = this.toByteArray();
        if (byteArrayResult.isZero) {
            return new BigDecimal(BigDecimal.ZERO.toBigInteger(), 0);
        }
        BigInteger bigInt = new BigInteger(byteArrayResult.bytes);
        return new BigDecimal(bigInt, this.scale);
    }

    public String toString() {
        BigDecimal bigDecimal = this.toBigDecimal();
        return bigDecimal.toString();
    }

    public int signum() {
        return CompressedBigDecimal.signumInternal(this.getArraySize(), this, CompressedBigDecimal::getArrayEntry);
    }

    public boolean isNegative() {
        return this.getArrayEntry(this.getArraySize() - 1) < 0;
    }

    public boolean isNonNegative() {
        return this.getArrayEntry(this.getArraySize() - 1) >= 0;
    }

    public boolean isZero() {
        boolean isZero = true;
        for (int i = this.getArraySize() - 1; i >= 0; --i) {
            if (this.getArrayEntry(i) == 0) continue;
            isZero = false;
            break;
        }
        return isZero;
    }

    protected static <S> int signumInternal(int size, S rhs, ToIntBiFunction<S, Integer> valFunc) {
        if (valFunc.applyAsInt(rhs, size - 1) < 0) {
            return -1;
        }
        int agg = 0;
        for (int ii = 0; ii < size; ++ii) {
            agg |= valFunc.applyAsInt(rhs, ii);
        }
        if (agg == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public int compareTo(CompressedBigDecimal o) {
        return this.compareTo(o, false);
    }

    public int compareTo(CompressedBigDecimal o, boolean expectOptimized) {
        if (super.equals(o)) {
            return 0;
        }
        if (this.getScale() == o.getScale()) {
            return CompressedBigDecimal.directCompareCompressedBigDecimal(this, o);
        }
        if (expectOptimized) {
            throw new IAE("expected optimized path", new Object[0]);
        }
        return this.toBigDecimal().compareTo(o.toBigDecimal());
    }

    private static int directCompareCompressedBigDecimal(CompressedBigDecimal lhs, CompressedBigDecimal rhs) {
        if (lhs.isNonNegative() && rhs.isNegative()) {
            return 1;
        }
        if (lhs.isNegative() && rhs.isNonNegative()) {
            return -1;
        }
        int size = Math.max(lhs.getArraySize(), rhs.getArraySize());
        int[] result = new int[size];
        int borrow = 0;
        long lhsExtension = lhs.getArrayEntry(lhs.getArraySize() - 1) < 0 ? 0xFFFFFFFFL : 0L;
        long rhsExtension = rhs.getArrayEntry(rhs.getArraySize() - 1) < 0 ? 0xFFFFFFFFL : 0L;
        boolean nonZeroValues = false;
        for (int i = 0; i < size; ++i) {
            long leftElement = i < lhs.getArraySize() ? 0xFFFFFFFFL & (long)lhs.getArrayEntry(i) : lhsExtension;
            long rightElement = i < rhs.getArraySize() ? 0xFFFFFFFFL & (long)rhs.getArrayEntry(i) : rhsExtension;
            long resultElement = leftElement - rightElement - (long)borrow;
            borrow = 0;
            if (resultElement < 0L) {
                borrow = 1;
                resultElement += 0x100000000L;
            }
            result[i] = (int)resultElement;
            if (nonZeroValues || resultElement == 0L) continue;
            nonZeroValues = true;
        }
        int signum = 0;
        if (nonZeroValues) {
            signum = result[size - 1] < 0 ? -1 : 1;
        }
        return signum;
    }

    public int hashCode() {
        return this.toBigDecimal().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompressedBigDecimal && this.toBigDecimal().equals(((CompressedBigDecimal)obj).toBigDecimal());
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().setScale(0, 4).intValue();
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().setScale(0, 4).longValue();
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    private static class ByteArrayResult {
        private final byte[] bytes;
        private final boolean isZero;

        public ByteArrayResult(byte[] bytes, boolean isZero) {
            this.bytes = bytes;
            this.isZero = isZero;
        }
    }
}

