/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.google.common.base.Predicate;
import java.io.IOException;
import org.apache.druid.java.util.common.RetryUtils;

public class CloudFilesUtils {
    public static final Predicate<Throwable> CLOUDFILESRETRY = new Predicate<Throwable>(){

        public boolean apply(Throwable e) {
            if (e == null) {
                return false;
            }
            if (e instanceof IOException) {
                return true;
            }
            return this.apply(e.getCause());
        }
    };

    public static <T> T retryCloudFilesOperation(RetryUtils.Task<T> f, int maxTries) throws Exception {
        return (T)RetryUtils.retry(f, CLOUDFILESRETRY, (int)maxTries);
    }

    public static String buildCloudFilesPath(String basePath, String fileName) {
        Object path = fileName;
        if (!basePath.isEmpty()) {
            int lastSlashIndex = basePath.lastIndexOf(47);
            if (lastSlashIndex != -1) {
                basePath = basePath.substring(0, lastSlashIndex);
            }
            path = basePath + "/" + fileName;
        }
        return path;
    }
}

