/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.cloudfiles.CloudFilesDataSegmentPuller;

@JsonTypeName(value="cloudfiles")
public class CloudFilesLoadSpec
implements LoadSpec {
    @JsonProperty
    private final String region;
    @JsonProperty
    private final String container;
    @JsonProperty
    private final String path;
    private final CloudFilesDataSegmentPuller puller;

    @JsonCreator
    public CloudFilesLoadSpec(@JsonProperty(value="region") String region, @JsonProperty(value="container") String container, @JsonProperty(value="path") String path, @JacksonInject CloudFilesDataSegmentPuller puller) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)path);
        this.container = container;
        this.region = region;
        this.path = path;
        this.puller = puller;
    }

    public LoadSpec.LoadSpecResult loadSegment(File file) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.region, this.container, this.path, file).size());
    }
}

