/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.storage.cloudfiles.CloudFilesDataSegmentPusherConfig;
import org.apache.druid.storage.cloudfiles.CloudFilesObject;
import org.apache.druid.storage.cloudfiles.CloudFilesObjectApiProxy;
import org.apache.druid.storage.cloudfiles.CloudFilesUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;
import org.jclouds.rackspace.cloudfiles.v1.CloudFilesApi;

public class CloudFilesDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(CloudFilesDataSegmentPusher.class);
    private final CloudFilesObjectApiProxy objectApi;
    private final CloudFilesDataSegmentPusherConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public CloudFilesDataSegmentPusher(CloudFilesApi cloudFilesApi, CloudFilesDataSegmentPusherConfig config, ObjectMapper jsonMapper) {
        this.config = config;
        String region = this.config.getRegion();
        String container = this.config.getContainer();
        this.objectApi = new CloudFilesObjectApiProxy(cloudFilesApi, region, container);
        this.jsonMapper = jsonMapper;
    }

    public String getPathForHadoop() {
        return null;
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public DataSegment push(File indexFilesDir, DataSegment inSegment, boolean useUniquePath) {
        return this.pushToPath(indexFilesDir, inSegment, this.getStorageDir(inSegment, useUniquePath));
    }

    public DataSegment pushToPath(File indexFilesDir, DataSegment inSegment, String storageDirSuffix) {
        DataSegment dataSegment;
        File descriptorFile;
        block7: {
            String segmentPath = CloudFilesUtils.buildCloudFilesPath(this.config.getBasePath(), storageDirSuffix);
            descriptorFile = null;
            File zipOutFile = null;
            try {
                File descFile = descriptorFile = File.createTempFile("descriptor", ".json");
                File outFile = zipOutFile = File.createTempFile("druid", "index.zip");
                long indexSize = CompressionUtils.zip((File)indexFilesDir, (File)zipOutFile);
                log.info("Copying segment[%s] to CloudFiles at location[%s]", new Object[]{inSegment.getId(), segmentPath});
                dataSegment = (DataSegment)CloudFilesUtils.retryCloudFilesOperation(() -> {
                    CloudFilesObject segmentData = new CloudFilesObject(segmentPath, outFile, this.objectApi.getRegion(), this.objectApi.getContainer());
                    log.info("Pushing %s.", new Object[]{segmentData.getPath()});
                    this.objectApi.put(segmentData);
                    Files.write(descFile.toPath(), this.jsonMapper.writeValueAsBytes((Object)inSegment), new OpenOption[0]);
                    CloudFilesObject descriptorData = new CloudFilesObject(segmentPath, descFile, this.objectApi.getRegion(), this.objectApi.getContainer());
                    log.info("Pushing %s.", new Object[]{descriptorData.getPath()});
                    this.objectApi.put(descriptorData);
                    DataSegment outSegment = inSegment.withSize(indexSize).withLoadSpec(this.makeLoadSpec(new URI(segmentData.getPath()))).withBinaryVersion(SegmentUtils.getVersionFromDir((File)indexFilesDir));
                    return outSegment;
                }, this.config.getOperationMaxRetries());
                if (zipOutFile == null) break block7;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (zipOutFile != null) {
                        log.info("Deleting zipped index File[%s]", new Object[]{zipOutFile});
                        zipOutFile.delete();
                    }
                    if (descriptorFile != null) {
                        log.info("Deleting descriptor file[%s]", new Object[]{descriptorFile});
                        descriptorFile.delete();
                    }
                    throw throwable;
                }
            }
            log.info("Deleting zipped index File[%s]", new Object[]{zipOutFile});
            zipOutFile.delete();
        }
        if (descriptorFile != null) {
            log.info("Deleting descriptor file[%s]", new Object[]{descriptorFile});
            descriptorFile.delete();
        }
        return dataSegment;
    }

    public Map<String, Object> makeLoadSpec(URI uri) {
        return ImmutableMap.of((Object)"type", (Object)"cloudfiles", (Object)"region", (Object)this.objectApi.getRegion(), (Object)"container", (Object)this.objectApi.getContainer(), (Object)"path", (Object)uri.toString());
    }
}

