/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.cloudfiles.CloudFilesByteSource;
import org.apache.druid.storage.cloudfiles.CloudFilesObjectApiProxy;
import org.apache.druid.storage.cloudfiles.CloudFilesUtils;
import org.apache.druid.utils.CompressionUtils;
import org.jclouds.rackspace.cloudfiles.v1.CloudFilesApi;

public class CloudFilesDataSegmentPuller {
    private static final Logger log = new Logger(CloudFilesDataSegmentPuller.class);
    private final CloudFilesApi cloudFilesApi;

    @Inject
    public CloudFilesDataSegmentPuller(CloudFilesApi cloudFilesApi) {
        this.cloudFilesApi = cloudFilesApi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FileUtils.FileCopyResult getSegmentFiles(String region, String container, String path, File outDir) throws SegmentLoadingException {
        FileUtils.FileCopyResult fileCopyResult;
        CloudFilesObjectApiProxy objectApi = new CloudFilesObjectApiProxy(this.cloudFilesApi, region, container);
        CloudFilesByteSource byteSource = new CloudFilesByteSource(objectApi, path);
        try {
            FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)byteSource, (File)outDir, CloudFilesUtils.CLOUDFILESRETRY, (boolean)false);
            log.info("Loaded %d bytes from [%s] to [%s]", new Object[]{result.size(), path, outDir.getAbsolutePath()});
            fileCopyResult = result;
        }
        catch (Exception e) {
            try {
                try {
                    FileUtils.deleteDirectory((File)outDir);
                    throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
                }
                catch (IOException ioe) {
                    log.warn((Throwable)ioe, "Failed to remove output directory [%s] for segment pulled from [%s]", new Object[]{outDir.getAbsolutePath(), path});
                }
                throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    byteSource.closeStream();
                    throw throwable;
                }
                catch (IOException ioe) {
                    log.warn((Throwable)ioe, "Failed to close payload for segmente pulled from [%s]", new Object[]{path});
                }
                throw throwable;
            }
        }
        try {
            byteSource.closeStream();
            return fileCopyResult;
        }
        catch (IOException ioe) {
            log.warn((Throwable)ioe, "Failed to close payload for segmente pulled from [%s]", new Object[]{path});
        }
        return fileCopyResult;
    }
}

