/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.dropwizard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.druid.emitter.dropwizard.DropwizardReporter;

public class DropwizardEmitterConfig {
    private static int DEFAULT_METRICS_REGISTRY_SIZE = 100000000;
    @JsonProperty
    private final List<DropwizardReporter> reporters;
    @JsonProperty
    private final String prefix;
    @JsonProperty
    private final Boolean includeHost;
    @JsonProperty
    private final String dimensionMapPath;
    @JsonProperty
    private final List<String> alertEmitters;
    @JsonProperty
    private final int maxMetricsRegistrySize;

    @JsonCreator
    public DropwizardEmitterConfig(@JsonProperty(value="reporters") List<DropwizardReporter> reporters, @JsonProperty(value="prefix") String prefix, @JsonProperty(value="includeHost") Boolean includeHost, @JsonProperty(value="dimensionMapPath") String dimensionMapPath, @JsonProperty(value="alertEmitters") List<String> alertEmitters, @JsonProperty(value="maxMetricsRegistrySize") Integer maxMetricsRegistrySize) {
        Preconditions.checkArgument((reporters != null && !reporters.isEmpty() ? 1 : 0) != 0);
        this.reporters = reporters;
        this.prefix = prefix;
        this.alertEmitters = alertEmitters == null ? Collections.emptyList() : alertEmitters;
        this.includeHost = includeHost != null ? includeHost : true;
        this.dimensionMapPath = dimensionMapPath;
        this.maxMetricsRegistrySize = maxMetricsRegistrySize == null ? DEFAULT_METRICS_REGISTRY_SIZE : maxMetricsRegistrySize;
    }

    @JsonProperty
    public List<DropwizardReporter> getReporters() {
        return this.reporters;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public Boolean getIncludeHost() {
        return this.includeHost;
    }

    @JsonProperty
    public String getDimensionMapPath() {
        return this.dimensionMapPath;
    }

    @JsonProperty
    public List<String> getAlertEmitters() {
        return this.alertEmitters;
    }

    @JsonProperty
    public int getMaxMetricsRegistrySize() {
        return this.maxMetricsRegistrySize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropwizardEmitterConfig that = (DropwizardEmitterConfig)o;
        return this.maxMetricsRegistrySize == that.maxMetricsRegistrySize && Objects.equals(this.reporters, that.reporters) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.includeHost, that.includeHost) && Objects.equals(this.dimensionMapPath, that.dimensionMapPath) && Objects.equals(this.alertEmitters, that.alertEmitters);
    }

    public int hashCode() {
        return Objects.hash(this.reporters, this.prefix, this.includeHost, this.dimensionMapPath, this.alertEmitters, this.maxMetricsRegistrySize);
    }

    public String toString() {
        return "DropwizardEmitterConfig{reporters=" + this.reporters + ", prefix='" + this.prefix + "', includeHost=" + this.includeHost + ", dimensionMapPath='" + this.dimensionMapPath + "', alertEmitters=" + this.alertEmitters + ", maxMetricsRegistrySize=" + this.maxMetricsRegistrySize + "}";
    }
}

