/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.dropwizard;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.emitter.dropwizard.DropwizardMetricSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class DropwizardConverter {
    private static final Logger log = new Logger(DropwizardConverter.class);
    private final Map<String, DropwizardMetricSpec> metricMap;

    public DropwizardConverter(ObjectMapper mapper, String dimensionMapPath) {
        this.metricMap = this.readMap(mapper, dimensionMapPath);
    }

    @Nullable
    public DropwizardMetricSpec addFilteredUserDims(String service, String metric, Map<String, Object> userDims, Map<String, String> filteredDimensions) {
        DropwizardMetricSpec metricSpec = null;
        DropwizardMetricSpec dropwizardMetricSpec = this.metricMap.get(metric);
        if (dropwizardMetricSpec != null) {
            metricSpec = dropwizardMetricSpec;
        } else if (this.metricMap.containsKey(service + "-" + metric)) {
            metricSpec = this.metricMap.get(service + "-" + metric);
        }
        if (metricSpec != null) {
            for (String dim : metricSpec.getDimensions()) {
                if (!userDims.containsKey(dim)) continue;
                filteredDimensions.put(dim, userDims.get(dim).toString());
            }
            return metricSpec;
        }
        return null;
    }

    private Map<String, DropwizardMetricSpec> readMap(ObjectMapper mapper, String dimensionMapPath) {
        Map map;
        block8: {
            InputStream is = this.openDimensionMapFile(dimensionMapPath);
            try {
                map = (Map)mapper.readerFor((TypeReference)new TypeReference<Map<String, DropwizardMetricSpec>>(){}).readValue(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ISE((Throwable)e, "Failed to parse metric dimensions and types", new Object[0]);
                }
            }
            is.close();
        }
        return map;
    }

    private InputStream openDimensionMapFile(@Nullable String dimensionMapPath) throws IOException {
        if (Strings.isNullOrEmpty((String)dimensionMapPath)) {
            log.info("Using default metric dimension and types", new Object[0]);
            return this.getClass().getClassLoader().getResourceAsStream("defaultMetricDimensions.json");
        }
        log.info("Using metric dimensions at types at [%s]", new Object[]{dimensionMapPath});
        return new FileInputStream(dimensionMapPath);
    }
}

