/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.sql.calcite.expression.builtin.QueryLookupOperatorConversion;

public class CoalesceLookupRule
extends RelOptRule
implements SubstitutionRule {
    public CoalesceLookupRule() {
        super(CoalesceLookupRule.operand(RelNode.class, (RelOptRuleOperandChildren)CoalesceLookupRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        CoalesceLookupShuttle shuttle;
        RelNode oldNode = call.rel(0);
        RelNode newNode = oldNode.accept((RexShuttle)(shuttle = new CoalesceLookupShuttle(oldNode.getCluster().getRexBuilder())));
        if (newNode != oldNode) {
            call.transformTo(newNode);
            call.getPlanner().prune(oldNode);
        }
    }

    private static class CoalesceLookupShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public CoalesceLookupShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            RexCall lookupCall;
            if (call.getKind() == SqlKind.COALESCE && call.getOperands().size() == 2 && ((RexNode)call.getOperands().get(0)).isA(SqlKind.OTHER_FUNCTION) && (lookupCall = (RexCall)call.getOperands().get(0)).getOperator().equals((Object)QueryLookupOperatorConversion.SQL_FUNCTION) && lookupCall.getOperands().size() == 2 && RexUtil.isLiteral((RexNode)((RexNode)call.getOperands().get(1)), (boolean)true)) {
                return this.rexBuilder.makeCast(call.getType(), this.rexBuilder.makeCall((SqlOperator)QueryLookupOperatorConversion.SQL_FUNCTION, new RexNode[]{(RexNode)lookupCall.getOperands().get(0), (RexNode)lookupCall.getOperands().get(1), (RexNode)call.getOperands().get(1)}), true, false);
            }
            return super.visitCall(call);
        }
    }
}

