/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class DruidRexExecutor
implements RexExecutor {
    private static final RowSignature EMPTY_ROW_SIGNATURE = RowSignature.builder().build();
    private final PlannerContext plannerContext;

    public DruidRexExecutor(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        for (RexNode constExp : constExps) {
            void var10_10;
            DruidExpression druidExpression = Expressions.toDruidExpression(this.plannerContext, EMPTY_ROW_SIGNATURE, constExp);
            if (druidExpression == null) {
                reducedValues.add(constExp);
                continue;
            }
            SqlTypeName sqlTypeName = constExp.getType().getSqlTypeName();
            Expr expr = Parser.parse((String)druidExpression.getExpression(), (ExprMacroTable)this.plannerContext.getPlannerToolbox().exprMacroTable());
            ExprEval exprResult = expr.eval(InputBindings.validateConstant((Expr)expr));
            if (sqlTypeName == SqlTypeName.BOOLEAN) {
                if (exprResult.value() == null) {
                    RexLiteral rexLiteral = rexBuilder.makeNullLiteral(constExp.getType());
                } else {
                    RexNode rexNode = rexBuilder.makeLiteral((Object)exprResult.asBoolean(), constExp.getType(), true);
                }
            } else if (sqlTypeName == SqlTypeName.DATE) {
                if (exprResult.isNumericNull()) {
                    if (!constExp.getType().isNullable()) throw InvalidSqlInput.exception((String)"Illegal DATE constant [%s]", (Object[])new Object[]{constExp});
                    RexLiteral rexLiteral = rexBuilder.makeNullLiteral(constExp.getType());
                } else {
                    RexLiteral rexLiteral = rexBuilder.makeDateLiteral(Calcites.jodaToCalciteDateString(DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone()));
                }
            } else if (sqlTypeName == SqlTypeName.TIMESTAMP) {
                if (exprResult.isNumericNull()) {
                    if (!constExp.getType().isNullable()) throw InvalidSqlInput.exception((String)"Illegal TIMESTAMP constant [%s]", (Object[])new Object[]{constExp});
                    RexLiteral rexLiteral = rexBuilder.makeNullLiteral(constExp.getType());
                } else {
                    RexLiteral rexLiteral = Calcites.jodaToCalciteTimestampLiteral(rexBuilder, DateTimes.utc((long)exprResult.asLong()), this.plannerContext.getTimeZone(), constExp.getType().getPrecision());
                }
            } else if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
                if (exprResult.isNumericNull()) {
                    RexLiteral rexLiteral = rexBuilder.makeNullLiteral(constExp.getType());
                } else {
                    BigDecimal bigDecimal;
                    if (exprResult.type().is((TypeDescriptor)ExprType.LONG)) {
                        bigDecimal = BigDecimal.valueOf(exprResult.asLong());
                    } else {
                        double exprResultDouble = exprResult.asDouble();
                        if (Double.isNaN(exprResultDouble) || Double.isInfinite(exprResultDouble)) {
                            throw InvalidSqlInput.exception((String)"Expression [%s] evaluates to an unsupported value [%s], expected something that can be a Double.  Consider casting with 'CAST(<col> AS BIGINT)'", (Object[])new Object[]{druidExpression.getExpression(), exprResultDouble});
                        }
                        bigDecimal = BigDecimal.valueOf(exprResult.asDouble());
                    }
                    RexNode rexNode = rexBuilder.makeLiteral((Object)bigDecimal, constExp.getType(), true);
                }
            } else if (sqlTypeName == SqlTypeName.ARRAY) {
                Number longVal;
                assert (exprResult.isArray());
                Object[] array = exprResult.asArray();
                if (array == null) {
                    RexLiteral rexLiteral = rexBuilder.makeNullLiteral(constExp.getType());
                } else if (SqlTypeName.NUMERIC_TYPES.contains(constExp.getType().getComponentType().getSqlTypeName())) {
                    if (exprResult.type().getElementType().is((TypeDescriptor)ExprType.LONG)) {
                        ArrayList<BigDecimal> resultAsBigDecimalList = new ArrayList<BigDecimal>(array.length);
                        for (Object val : exprResult.castTo(ExpressionType.LONG_ARRAY).asArray()) {
                            longVal = (Number)val;
                            if (longVal == null) {
                                resultAsBigDecimalList.add(null);
                                continue;
                            }
                            resultAsBigDecimalList.add(BigDecimal.valueOf(longVal.longValue()));
                        }
                        RexNode rexNode = rexBuilder.makeLiteral(resultAsBigDecimalList, constExp.getType(), true);
                    } else {
                        ArrayList<BigDecimal> resultAsBigDecimalList = new ArrayList<BigDecimal>(array.length);
                        for (Object val : exprResult.castTo(ExpressionType.fromColumnType((TypeSignature)druidExpression.getDruidType())).asArray()) {
                            Number doubleVal = (Number)val;
                            if (doubleVal == null) {
                                resultAsBigDecimalList.add(null);
                                continue;
                            }
                            if (Double.isNaN(doubleVal.doubleValue()) || Double.isInfinite(doubleVal.doubleValue())) {
                                throw InvalidSqlInput.exception((String)"Expression [%s] was expected to generate values that are all Doubles, but entry at index[%d] was not: [%s].  Consider Casting values to ensure a consistent type.", (Object[])new Object[]{druidExpression.getExpression(), resultAsBigDecimalList.size(), doubleVal});
                            }
                            resultAsBigDecimalList.add(BigDecimal.valueOf(doubleVal.doubleValue()));
                        }
                        RexNode rexNode = rexBuilder.makeLiteral(resultAsBigDecimalList, constExp.getType(), true);
                    }
                } else if (constExp.getType().getComponentType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                    ArrayList<Boolean> resultAsBooleanList = new ArrayList<Boolean>(array.length);
                    for (Object val : exprResult.castTo(ExpressionType.LONG_ARRAY).asArray()) {
                        longVal = (Number)val;
                        if (longVal == null) {
                            resultAsBooleanList.add(null);
                            continue;
                        }
                        resultAsBooleanList.add(Evals.asBoolean((long)longVal.longValue()));
                    }
                    RexNode rexNode = rexBuilder.makeLiteral(resultAsBooleanList, constExp.getType(), true);
                } else {
                    RexNode rexNode = rexBuilder.makeLiteral(Arrays.asList(array), constExp.getType(), true);
                }
            } else if (sqlTypeName == SqlTypeName.OTHER) {
                RexNode rexNode = constExp;
            } else if (exprResult.isArray()) {
                RexNode rexNode = constExp;
            } else {
                RexNode rexNode = rexBuilder.makeLiteral(exprResult.value(), constExp.getType(), true);
            }
            reducedValues.add((RexNode)var10_10);
        }
    }
}

