/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class SubstringOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("SUBSTRING").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER).functionCategory(SqlFunctionCategory.STRING).returnTypeInference(ReturnTypes.ARG0.andThen(SqlTypeTransforms.FORCE_NULLABLE)).requiredOperandCount(2).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        String lengthExpr;
        Integer lengthLiteral;
        String adjustedIndexExpr;
        Integer adjustedIndexLiteral;
        RexCall call = (RexCall)rexNode;
        List operands = call.getOperands();
        RexNode inputNode = (RexNode)operands.get(0);
        DruidExpression input = Expressions.toDruidExpression(plannerContext, rowSignature, inputNode);
        if (input == null) {
            return null;
        }
        RexNode indexNode = (RexNode)operands.get(1);
        Integer n = adjustedIndexLiteral = RexUtil.isLiteral((RexNode)indexNode, (boolean)true) ? Integer.valueOf(RexLiteral.intValue((RexNode)indexNode) - 1) : null;
        if (adjustedIndexLiteral != null) {
            adjustedIndexExpr = String.valueOf(adjustedIndexLiteral);
        } else {
            DruidExpression indexExpr = Expressions.toDruidExpression(plannerContext, rowSignature, indexNode);
            if (indexExpr == null) {
                return null;
            }
            adjustedIndexExpr = StringUtils.format((String)"(%s - 1)", (Object[])new Object[]{indexExpr.getExpression()});
        }
        if (adjustedIndexExpr == null) {
            return null;
        }
        RexNode lengthNode = operands.size() > 2 ? (RexNode)operands.get(2) : null;
        Integer n2 = lengthLiteral = lengthNode != null && RexUtil.isLiteral((RexNode)lengthNode, (boolean)true) ? Integer.valueOf(RexLiteral.intValue((RexNode)lengthNode)) : null;
        if (lengthNode != null) {
            DruidExpression lengthExpression = Expressions.toDruidExpression(plannerContext, rowSignature, lengthNode);
            if (lengthExpression == null) {
                return null;
            }
            lengthExpr = lengthExpression.getExpression();
        } else {
            lengthExpr = "-1";
        }
        return input.map(simpleExtraction -> {
            if (adjustedIndexLiteral != null && (lengthNode == null || lengthLiteral != null)) {
                return simpleExtraction.cascade((ExtractionFn)new SubstringDimExtractionFn(adjustedIndexLiteral.intValue(), lengthLiteral));
            }
            return null;
        }, expression -> StringUtils.format((String)"substring(%s, %s, %s)", (Object[])new Object[]{expression, adjustedIndexExpr, lengthExpr}));
    }
}

