/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.FunctionParameterImpl;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.table.ExternalTable;

public class Externals {
    public static final ResourceAction EXTERNAL_RESOURCE_ACTION = new ResourceAction(new Resource("EXTERNAL", "EXTERNAL"), Action.READ);

    public static List<FunctionParameter> convertParameters(TableFunction fn) {
        return Externals.convertToCalciteParameters(fn.parameters());
    }

    private static List<FunctionParameter> convertToCalciteParameters(List<TableFunction.ParameterDefn> paramDefns) {
        RelDataTypeFactory typeFactory = DruidTypeSystem.TYPE_FACTORY;
        ImmutableList.Builder params = ImmutableList.builder();
        for (int i = 0; i < paramDefns.size(); ++i) {
            RelDataType paramType;
            TableFunction.ParameterDefn paramDefn = paramDefns.get(i);
            switch (paramDefn.type()) {
                case BIGINT: {
                    paramType = typeFactory.createJavaType(Long.class);
                    break;
                }
                case BOOLEAN: {
                    paramType = typeFactory.createJavaType(Boolean.class);
                    break;
                }
                case VARCHAR: {
                    paramType = typeFactory.createJavaType(String.class);
                    break;
                }
                case VARCHAR_ARRAY: {
                    paramType = typeFactory.createArrayType(typeFactory.createJavaType(String.class), -1L);
                    break;
                }
                default: {
                    throw new ISE("Undefined parameter type: %s", new Object[]{paramDefn.type().sqlName()});
                }
            }
            params.add((Object)new FunctionParameterImpl(i, paramDefn.name(), paramType, paramDefn.isOptional()));
        }
        return params.build();
    }

    public static List<RelDataType> dataTypes(List<FunctionParameter> parameters) {
        return parameters.stream().map(parameter -> parameter.getType(DruidTypeSystem.TYPE_FACTORY)).collect(Collectors.toList());
    }

    public static SqlOperandMetadata variadic(final List<FunctionParameter> params) {
        int min = 0;
        for (FunctionParameter param : params) {
            if (param.isOptional()) continue;
            ++min;
        }
        final SqlOperandCountRange range = SqlOperandCountRanges.between((int)min, (int)params.size());
        return new SqlOperandMetadata(){

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return range.isValidCount(callBinding.getOperandCount());
            }

            public SqlOperandCountRange getOperandCountRange() {
                return range;
            }

            public boolean isFixedParameters() {
                return true;
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(...)";
            }

            public boolean isOptional(int i) {
                return true;
            }

            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                ArrayList<RelDataType> types = new ArrayList<RelDataType>(params.size());
                for (FunctionParameter param : params) {
                    types.add(param.getType(typeFactory));
                }
                return types;
            }

            public List<String> paramNames() {
                ArrayList<String> names = new ArrayList<String>(params.size());
                for (FunctionParameter param : params) {
                    names.add(param.getName());
                }
                return names;
            }
        };
    }

    public static Map<String, Object> convertArguments(TableFunction fn, List<?> arguments) {
        List params = fn.parameters();
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            Object value = arguments.get(i);
            if (value == null) continue;
            argMap.put(((TableFunction.ParameterDefn)params.get(i)).name(), value);
        }
        return argMap;
    }

    public static List<ColumnSpec> convertColumns(SqlNodeList schema) {
        ArrayList<ColumnSpec> columns = new ArrayList<ColumnSpec>();
        for (int i = 0; i < schema.size(); i += 2) {
            String name = Externals.convertName((SqlIdentifier)schema.get(i));
            String sqlType = Externals.convertType(name, (SqlDataTypeSpec)schema.get(i + 1));
            columns.add(new ColumnSpec(name, sqlType, null));
        }
        return columns;
    }

    private static String convertName(SqlIdentifier ident) {
        if (!ident.isSimple()) {
            throw new IAE(StringUtils.format((String)"Column [%s] must have a simple name", (Object[])new Object[]{ident}), new Object[0]);
        }
        return ident.getSimple();
    }

    private static String convertType(String name, SqlDataTypeSpec dataType) {
        SqlTypeNameSpec spec = dataType.getTypeNameSpec();
        if (spec == null) {
            throw Externals.unsupportedType(name, dataType);
        }
        SqlIdentifier typeNameIdentifier = spec.getTypeName();
        if (typeNameIdentifier == null || !typeNameIdentifier.isSimple()) {
            throw Externals.unsupportedType(name, dataType);
        }
        String simpleName = typeNameIdentifier.getSimple();
        if (StringUtils.toLowerCase((String)simpleName).startsWith("complex<")) {
            return simpleName;
        }
        SqlTypeName type = SqlTypeName.get((String)simpleName);
        if (type == null) {
            throw Externals.unsupportedType(name, dataType);
        }
        if (SqlTypeName.CHAR_TYPES.contains(type)) {
            return SqlTypeName.VARCHAR.name();
        }
        if (SqlTypeName.INT_TYPES.contains(type)) {
            return SqlTypeName.BIGINT.name();
        }
        switch (type) {
            case DOUBLE: {
                return SqlType.DOUBLE.name();
            }
            case FLOAT: 
            case REAL: {
                return SqlType.FLOAT.name();
            }
            case ARRAY: {
                return Externals.convertType(name, dataType.getComponentTypeSpec()) + " " + SqlType.ARRAY.name();
            }
        }
        throw Externals.unsupportedType(name, dataType);
    }

    private static RuntimeException unsupportedType(String name, SqlDataTypeSpec dataType) {
        return new IAE(StringUtils.format((String)"Column [%s] has an unsupported type: [%s]", (Object[])new Object[]{name, dataType}), new Object[0]);
    }

    public static ExternalTable buildExternalTable(ExternalTableSpec spec, ObjectMapper jsonMapper) {
        Optional timestampColumnTypeOptional = spec.signature.getColumnType("__time");
        if (timestampColumnTypeOptional.isPresent() && !((ColumnType)timestampColumnTypeOptional.get()).equals((Object)ColumnType.LONG)) {
            throw new ISE("EXTERN function with __time column can be used when __time column is of type long. Please change the column name to something other than __time", new Object[0]);
        }
        return Externals.toExternalTable(spec, jsonMapper, (Supplier<Set<String>>)spec.inputSourceTypesSupplier);
    }

    public static ResourceAction externalRead(String name) {
        return new ResourceAction(new Resource(name, "EXTERNAL"), Action.READ);
    }

    public static ExternalTable toExternalTable(ExternalTableSpec spec, ObjectMapper jsonMapper, Supplier<Set<String>> inputSourceTypesSupplier) {
        return new ExternalTable(new ExternalDataSource(spec.inputSource, spec.inputFormat, spec.signature), spec.signature, jsonMapper, inputSourceTypesSupplier);
    }
}

