/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.Resource;

public class AllowAllAuthorizer
implements Authorizer {
    @Nullable
    private final Policy policy;

    @JsonCreator
    public AllowAllAuthorizer(@JsonProperty(value="policy") @Nullable Policy policy) {
        this.policy = policy;
    }

    @Override
    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
        if (this.shouldApplyPolicy(resource, action)) {
            return Access.allowWithRestriction(this.policy);
        }
        return Access.OK;
    }

    private boolean shouldApplyPolicy(Resource resource, Action action) {
        return this.policy != null && AuthorizationUtils.shouldApplyPolicy(resource, action);
    }
}

