/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.timeline.DataSegment;

public class SegmentChangeRequestDrop
implements DataSegmentChangeRequest {
    private final DataSegment segment;

    @JsonCreator
    public SegmentChangeRequestDrop(@JsonUnwrapped DataSegment segment) {
        this.segment = segment;
    }

    @JsonProperty
    @JsonUnwrapped
    public DataSegment getSegment() {
        return this.segment;
    }

    @Override
    public void go(DataSegmentChangeHandler handler, @Nullable DataSegmentChangeCallback callback) {
        handler.removeSegment(this.segment, callback);
    }

    @Override
    public String asString() {
        return StringUtils.format((String)"DROP: %s", (Object[])new Object[]{this.segment.getId()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentChangeRequestDrop that = (SegmentChangeRequestDrop)o;
        return Objects.equals(this.segment, that.segment);
    }

    public int hashCode() {
        return Objects.hash(this.segment);
    }

    public String toString() {
        return "SegmentChangeRequestDrop{segment=" + String.valueOf(this.segment) + "}";
    }
}

