/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.common.config.Configs;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionStatistics;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CollectionUtils;

public class CompactionStatus {
    private static final CompactionStatus COMPLETE = new CompactionStatus(State.COMPLETE, null, null, null);
    private static final List<Function<Evaluator, CompactionStatus>> CHECKS = Arrays.asList(rec$ -> ((Evaluator)rec$).segmentsHaveBeenCompactedAtLeastOnce(), rec$ -> ((Evaluator)rec$).partitionsSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).indexSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).segmentGranularityIsUpToDate(), rec$ -> ((Evaluator)rec$).queryGranularityIsUpToDate(), rec$ -> ((Evaluator)rec$).rollupIsUpToDate(), rec$ -> ((Evaluator)rec$).dimensionsSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).metricsSpecIsUpToDate(), rec$ -> ((Evaluator)rec$).transformSpecFilterIsUpToDate(), rec$ -> ((Evaluator)rec$).projectionsAreUpToDate());
    private final State state;
    private final String reason;
    private final CompactionStatistics compactedStats;
    private final CompactionStatistics uncompactedStats;

    private CompactionStatus(State state, String reason, CompactionStatistics compactedStats, CompactionStatistics uncompactedStats) {
        this.state = state;
        this.reason = reason;
        this.compactedStats = compactedStats;
        this.uncompactedStats = uncompactedStats;
    }

    public boolean isComplete() {
        return this.state == State.COMPLETE;
    }

    public boolean isSkipped() {
        return this.state == State.SKIPPED;
    }

    public String getReason() {
        return this.reason;
    }

    public State getState() {
        return this.state;
    }

    public CompactionStatistics getCompactedStats() {
        return this.compactedStats;
    }

    public CompactionStatistics getUncompactedStats() {
        return this.uncompactedStats;
    }

    public String toString() {
        return "CompactionStatus{state=" + String.valueOf((Object)this.state) + ", reason=" + this.reason + ", compactedStats=" + String.valueOf(this.compactedStats) + ", uncompactedStats=" + String.valueOf(this.uncompactedStats) + "}";
    }

    public static CompactionStatus pending(String reasonFormat, Object ... args) {
        return new CompactionStatus(State.PENDING, StringUtils.format((String)reasonFormat, (Object[])args), null, null);
    }

    public static CompactionStatus pending(CompactionStatistics compactedStats, CompactionStatistics uncompactedStats, String reasonFormat, Object ... args) {
        return new CompactionStatus(State.PENDING, StringUtils.format((String)reasonFormat, (Object[])args), compactedStats, uncompactedStats);
    }

    private static <T> CompactionStatus completeIfNullOrEqual(String field, T configured, T current, Function<T, String> stringFunction) {
        if (configured == null || configured.equals(current)) {
            return COMPLETE;
        }
        return CompactionStatus.configChanged(field, configured, current, stringFunction);
    }

    private static <T> CompactionStatus configChanged(String field, T target, T current, Function<T, String> stringFunction) {
        return CompactionStatus.pending("'%s' mismatch: required[%s], current[%s]", field, target == null ? null : stringFunction.apply(target), current == null ? null : stringFunction.apply(current));
    }

    private static String asString(Granularity granularity) {
        if (granularity == null) {
            return null;
        }
        for (GranularityType type : GranularityType.values()) {
            if (!type.getDefaultGranularity().equals(granularity)) continue;
            return type.toString();
        }
        return granularity.toString();
    }

    private static String asString(PartitionsSpec partitionsSpec) {
        if (partitionsSpec instanceof DimensionRangePartitionsSpec) {
            DimensionRangePartitionsSpec rangeSpec = (DimensionRangePartitionsSpec)partitionsSpec;
            return StringUtils.format((String)"'range' on %s with %,d rows", (Object[])new Object[]{rangeSpec.getPartitionDimensions(), rangeSpec.getTargetRowsPerSegment()});
        }
        if (partitionsSpec instanceof HashedPartitionsSpec) {
            HashedPartitionsSpec hashedSpec = (HashedPartitionsSpec)partitionsSpec;
            return StringUtils.format((String)"'hashed' on %s with %,d rows", (Object[])new Object[]{hashedSpec.getPartitionDimensions(), hashedSpec.getTargetRowsPerSegment()});
        }
        if (partitionsSpec instanceof DynamicPartitionsSpec) {
            DynamicPartitionsSpec dynamicSpec = (DynamicPartitionsSpec)partitionsSpec;
            return StringUtils.format((String)"'dynamic' with %,d rows", (Object[])new Object[]{dynamicSpec.getMaxRowsPerSegment()});
        }
        return partitionsSpec.toString();
    }

    public static CompactionStatus skipped(String reasonFormat, Object ... args) {
        return new CompactionStatus(State.SKIPPED, StringUtils.format((String)reasonFormat, (Object[])args), null, null);
    }

    public static CompactionStatus running(String message) {
        return new CompactionStatus(State.RUNNING, message, null, null);
    }

    static CompactionStatus compute(CompactionCandidate candidateSegments, DataSourceCompactionConfig config) {
        return new Evaluator(candidateSegments, config).evaluate();
    }

    @Nullable
    static PartitionsSpec findPartitionsSpecFromConfig(ClientCompactionTaskQueryTuningConfig tuningConfig) {
        PartitionsSpec partitionsSpecFromTuningConfig = tuningConfig.getPartitionsSpec();
        if (partitionsSpecFromTuningConfig == null) {
            Long maxTotalRows = tuningConfig.getMaxTotalRows();
            Integer maxRowsPerSegment = tuningConfig.getMaxRowsPerSegment();
            if (maxTotalRows == null && maxRowsPerSegment == null) {
                return null;
            }
            return new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
        }
        if (partitionsSpecFromTuningConfig instanceof DynamicPartitionsSpec) {
            return new DynamicPartitionsSpec(partitionsSpecFromTuningConfig.getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)partitionsSpecFromTuningConfig).getMaxTotalRowsOr(Long.MAX_VALUE)));
        }
        if (partitionsSpecFromTuningConfig instanceof DimensionRangePartitionsSpec) {
            return CompactionStatus.getEffectiveRangePartitionsSpec((DimensionRangePartitionsSpec)partitionsSpecFromTuningConfig);
        }
        return partitionsSpecFromTuningConfig;
    }

    @Nullable
    private static List<DimensionSchema> getNonPartitioningDimensions(@Nullable List<DimensionSchema> dimensionSchemas, @Nullable PartitionsSpec partitionsSpec, @Nullable IndexSpec indexSpec) {
        IndexSpec effectiveIndexSpec = (indexSpec == null ? IndexSpec.getDefault() : indexSpec).getEffectiveSpec();
        if (dimensionSchemas == null || !(partitionsSpec instanceof DimensionRangePartitionsSpec)) {
            if (dimensionSchemas != null) {
                return dimensionSchemas.stream().map(dim -> dim.getEffectiveSchema(effectiveIndexSpec)).collect(Collectors.toList());
            }
            return null;
        }
        List partitionsDimensions = ((DimensionRangePartitionsSpec)partitionsSpec).getPartitionDimensions();
        return dimensionSchemas.stream().filter(dim -> !partitionsDimensions.contains(dim.getName())).map(dim -> dim.getEffectiveSchema(effectiveIndexSpec)).collect(Collectors.toList());
    }

    static DimensionRangePartitionsSpec getEffectiveRangePartitionsSpec(DimensionRangePartitionsSpec partitionsSpec) {
        return new DimensionRangePartitionsSpec(null, partitionsSpec.getMaxRowsPerSegment(), partitionsSpec.getPartitionDimensions(), partitionsSpec.isAssumeGrouped());
    }

    public static enum State {
        COMPLETE,
        PENDING,
        RUNNING,
        SKIPPED;

    }

    private static class Evaluator {
        private final DataSourceCompactionConfig compactionConfig;
        private final CompactionCandidate candidateSegments;
        private final ClientCompactionTaskQueryTuningConfig tuningConfig;
        private final UserCompactionTaskGranularityConfig configuredGranularitySpec;
        private final List<DataSegment> uncompactedSegments = new ArrayList<DataSegment>();
        private final Map<CompactionState, List<DataSegment>> unknownStateToSegments = new HashMap<CompactionState, List<DataSegment>>();

        private Evaluator(CompactionCandidate candidateSegments, DataSourceCompactionConfig compactionConfig) {
            this.candidateSegments = candidateSegments;
            this.compactionConfig = compactionConfig;
            this.tuningConfig = ClientCompactionTaskQueryTuningConfig.from(compactionConfig);
            this.configuredGranularitySpec = compactionConfig.getGranularitySpec();
        }

        private CompactionStatus evaluate() {
            CompactionStatus inputBytesCheck = this.inputBytesAreWithinLimit();
            if (inputBytesCheck.isSkipped()) {
                return inputBytesCheck;
            }
            List reasonsForCompaction = CHECKS.stream().map(f -> (CompactionStatus)f.apply(this)).filter(status -> !status.isComplete()).map(CompactionStatus::getReason).collect(Collectors.toList());
            List<DataSegment> compactedSegments = this.unknownStateToSegments.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (reasonsForCompaction.isEmpty()) {
                return COMPLETE;
            }
            return CompactionStatus.pending(Evaluator.createStats(compactedSegments), Evaluator.createStats(this.uncompactedSegments), (String)reasonsForCompaction.get(0), new Object[0]);
        }

        private CompactionStatus segmentsHaveBeenCompactedAtLeastOnce() {
            for (DataSegment segment : this.candidateSegments.getSegments()) {
                CompactionState segmentState = segment.getLastCompactionState();
                if (segmentState == null) {
                    this.uncompactedSegments.add(segment);
                    continue;
                }
                this.unknownStateToSegments.computeIfAbsent(segmentState, s -> new ArrayList()).add(segment);
            }
            if (this.uncompactedSegments.isEmpty()) {
                return COMPLETE;
            }
            return CompactionStatus.pending("not compacted yet", new Object[0]);
        }

        private CompactionStatus partitionsSpecIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::partitionsSpecIsUpToDate);
        }

        private CompactionStatus indexSpecIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::indexSpecIsUpToDate);
        }

        private CompactionStatus projectionsAreUpToDate() {
            return this.evaluateForAllCompactionStates(this::projectionsAreUpToDate);
        }

        private CompactionStatus segmentGranularityIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::segmentGranularityIsUpToDate);
        }

        private CompactionStatus rollupIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::rollupIsUpToDate);
        }

        private CompactionStatus queryGranularityIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::queryGranularityIsUpToDate);
        }

        private CompactionStatus dimensionsSpecIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::dimensionsSpecIsUpToDate);
        }

        private CompactionStatus metricsSpecIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::metricsSpecIsUpToDate);
        }

        private CompactionStatus transformSpecFilterIsUpToDate() {
            return this.evaluateForAllCompactionStates(this::transformSpecFilterIsUpToDate);
        }

        private CompactionStatus partitionsSpecIsUpToDate(CompactionState lastCompactionState) {
            PartitionsSpec existingPartionsSpec = lastCompactionState.getPartitionsSpec();
            if (existingPartionsSpec instanceof DimensionRangePartitionsSpec) {
                existingPartionsSpec = CompactionStatus.getEffectiveRangePartitionsSpec((DimensionRangePartitionsSpec)existingPartionsSpec);
            } else if (existingPartionsSpec instanceof DynamicPartitionsSpec) {
                existingPartionsSpec = new DynamicPartitionsSpec(existingPartionsSpec.getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)existingPartionsSpec).getMaxTotalRowsOr(Long.MAX_VALUE)));
            }
            return CompactionStatus.completeIfNullOrEqual("partitionsSpec", CompactionStatus.findPartitionsSpecFromConfig(this.tuningConfig), existingPartionsSpec, x$0 -> CompactionStatus.asString(x$0));
        }

        private CompactionStatus indexSpecIsUpToDate(CompactionState lastCompactionState) {
            return CompactionStatus.completeIfNullOrEqual("indexSpec", ((IndexSpec)Configs.valueOrDefault((Object)this.tuningConfig.getIndexSpec(), (Object)IndexSpec.getDefault())).getEffectiveSpec(), lastCompactionState.getIndexSpec().getEffectiveSpec(), String::valueOf);
        }

        private CompactionStatus projectionsAreUpToDate(CompactionState lastCompactionState) {
            return CompactionStatus.completeIfNullOrEqual("projections", this.compactionConfig.getProjections(), lastCompactionState.getProjections(), String::valueOf);
        }

        private CompactionStatus inputBytesAreWithinLimit() {
            long inputSegmentSize = this.compactionConfig.getInputSegmentSizeBytes();
            if (this.candidateSegments.getTotalBytes() > inputSegmentSize) {
                return CompactionStatus.skipped("'inputSegmentSize' exceeded: Total segment size[%d] is larger than allowed inputSegmentSize[%d]", this.candidateSegments.getTotalBytes(), inputSegmentSize);
            }
            return COMPLETE;
        }

        private CompactionStatus segmentGranularityIsUpToDate(CompactionState lastCompactionState) {
            Granularity existingSegmentGranularity;
            if (this.configuredGranularitySpec == null || this.configuredGranularitySpec.getSegmentGranularity() == null) {
                return COMPLETE;
            }
            Granularity configuredSegmentGranularity = this.configuredGranularitySpec.getSegmentGranularity();
            UserCompactionTaskGranularityConfig existingGranularitySpec = Evaluator.getGranularitySpec(lastCompactionState);
            Granularity granularity = existingSegmentGranularity = existingGranularitySpec == null ? null : existingGranularitySpec.getSegmentGranularity();
            if (configuredSegmentGranularity.equals(existingSegmentGranularity)) {
                return COMPLETE;
            }
            if (existingSegmentGranularity == null) {
                List<DataSegment> segmentsForState = this.unknownStateToSegments.get(lastCompactionState);
                boolean needsCompaction = segmentsForState.stream().anyMatch(segment -> !configuredSegmentGranularity.isAligned(segment.getInterval()));
                if (needsCompaction) {
                    return CompactionStatus.pending("segmentGranularity: segments do not align with target[%s]", CompactionStatus.asString(configuredSegmentGranularity));
                }
            } else {
                return CompactionStatus.configChanged("segmentGranularity", configuredSegmentGranularity, existingSegmentGranularity, x$0 -> CompactionStatus.asString(x$0));
            }
            return COMPLETE;
        }

        private CompactionStatus rollupIsUpToDate(CompactionState lastCompactionState) {
            if (this.configuredGranularitySpec == null) {
                return COMPLETE;
            }
            UserCompactionTaskGranularityConfig existingGranularitySpec = Evaluator.getGranularitySpec(lastCompactionState);
            return CompactionStatus.completeIfNullOrEqual("rollup", this.configuredGranularitySpec.isRollup(), existingGranularitySpec == null ? null : existingGranularitySpec.isRollup(), String::valueOf);
        }

        private CompactionStatus queryGranularityIsUpToDate(CompactionState lastCompactionState) {
            if (this.configuredGranularitySpec == null) {
                return COMPLETE;
            }
            UserCompactionTaskGranularityConfig existingGranularitySpec = Evaluator.getGranularitySpec(lastCompactionState);
            return CompactionStatus.completeIfNullOrEqual("queryGranularity", this.configuredGranularitySpec.getQueryGranularity(), existingGranularitySpec == null ? null : existingGranularitySpec.getQueryGranularity(), x$0 -> CompactionStatus.asString(x$0));
        }

        private CompactionStatus dimensionsSpecIsUpToDate(CompactionState lastCompactionState) {
            if (this.compactionConfig.getDimensionsSpec() == null) {
                return COMPLETE;
            }
            List<DimensionSchema> existingDimensions = CompactionStatus.getNonPartitioningDimensions(lastCompactionState.getDimensionsSpec() == null ? null : lastCompactionState.getDimensionsSpec().getDimensions(), lastCompactionState.getPartitionsSpec(), lastCompactionState.getIndexSpec());
            List<DimensionSchema> configuredDimensions = CompactionStatus.getNonPartitioningDimensions(this.compactionConfig.getDimensionsSpec().getDimensions(), this.compactionConfig.getTuningConfig() == null ? null : this.compactionConfig.getTuningConfig().getPartitionsSpec(), this.compactionConfig.getTuningConfig() == null ? IndexSpec.getDefault() : this.compactionConfig.getTuningConfig().getIndexSpec());
            return CompactionStatus.completeIfNullOrEqual("dimensionsSpec", configuredDimensions, existingDimensions, String::valueOf);
        }

        private CompactionStatus metricsSpecIsUpToDate(CompactionState lastCompactionState) {
            Object[] existingMetricsSpec;
            Object[] configuredMetricsSpec = this.compactionConfig.getMetricsSpec();
            if (ArrayUtils.isEmpty((Object[])configuredMetricsSpec)) {
                return COMPLETE;
            }
            List metricSpecList = lastCompactionState.getMetricsSpec();
            Object[] objectArray = existingMetricsSpec = CollectionUtils.isNullOrEmpty((Collection)metricSpecList) ? null : metricSpecList.toArray(new AggregatorFactory[0]);
            if (existingMetricsSpec == null || !Arrays.deepEquals(configuredMetricsSpec, existingMetricsSpec)) {
                return CompactionStatus.configChanged("metricsSpec", configuredMetricsSpec, existingMetricsSpec, Arrays::toString);
            }
            return COMPLETE;
        }

        private CompactionStatus transformSpecFilterIsUpToDate(CompactionState lastCompactionState) {
            if (this.compactionConfig.getTransformSpec() == null) {
                return COMPLETE;
            }
            CompactionTransformSpec existingTransformSpec = lastCompactionState.getTransformSpec();
            return CompactionStatus.completeIfNullOrEqual("transformSpec filter", this.compactionConfig.getTransformSpec().getFilter(), existingTransformSpec == null ? null : existingTransformSpec.getFilter(), String::valueOf);
        }

        private CompactionStatus evaluateForAllCompactionStates(Function<CompactionState, CompactionStatus> check) {
            CompactionStatus firstIncompleteStatus = null;
            for (CompactionState state : List.copyOf(this.unknownStateToSegments.keySet())) {
                CompactionStatus status = check.apply(state);
                if (status.isComplete()) continue;
                this.uncompactedSegments.addAll((Collection<DataSegment>)this.unknownStateToSegments.remove(state));
                if (firstIncompleteStatus != null) continue;
                firstIncompleteStatus = status;
            }
            return firstIncompleteStatus == null ? COMPLETE : firstIncompleteStatus;
        }

        private static UserCompactionTaskGranularityConfig getGranularitySpec(CompactionState compactionState) {
            return UserCompactionTaskGranularityConfig.from(compactionState.getGranularitySpec());
        }

        private static CompactionStatistics createStats(List<DataSegment> segments) {
            Set segmentIntervals = segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet());
            long totalBytes = segments.stream().mapToLong(DataSegment::getSize).sum();
            return CompactionStatistics.create(totalBytes, segments.size(), segmentIntervals.size());
        }
    }
}

