/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.server.compaction.CompactionStatistics;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class CompactionCandidate {
    private final List<DataSegment> segments;
    private final Interval umbrellaInterval;
    private final Interval compactionInterval;
    private final String dataSource;
    private final long totalBytes;
    private final int numIntervals;
    private final CompactionStatus currentStatus;

    public static CompactionCandidate from(List<DataSegment> segments, @Nullable Granularity targetSegmentGranularity) {
        if (segments == null || segments.isEmpty()) {
            throw InvalidInput.exception((String)"Segments to compact must be non-empty", (Object[])new Object[0]);
        }
        Set segmentIntervals = segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet());
        Interval umbrellaInterval = JodaUtils.umbrellaInterval(segmentIntervals);
        Interval compactionInterval = targetSegmentGranularity == null ? umbrellaInterval : JodaUtils.umbrellaInterval((Iterable)targetSegmentGranularity.getIterable(umbrellaInterval));
        return new CompactionCandidate(segments, umbrellaInterval, compactionInterval, segmentIntervals.size(), null);
    }

    private CompactionCandidate(List<DataSegment> segments, Interval umbrellaInterval, Interval compactionInterval, int numDistinctSegmentIntervals, @Nullable CompactionStatus currentStatus) {
        this.segments = segments;
        this.totalBytes = segments.stream().mapToLong(DataSegment::getSize).sum();
        this.umbrellaInterval = umbrellaInterval;
        this.compactionInterval = compactionInterval;
        this.numIntervals = numDistinctSegmentIntervals;
        this.dataSource = segments.get(0).getDataSource();
        this.currentStatus = currentStatus;
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int numSegments() {
        return this.segments.size();
    }

    public Interval getUmbrellaInterval() {
        return this.umbrellaInterval;
    }

    public Interval getCompactionInterval() {
        return this.compactionInterval;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public CompactionStatistics getStats() {
        return CompactionStatistics.create(this.totalBytes, this.numSegments(), this.numIntervals);
    }

    @Nullable
    public CompactionStatistics getCompactedStats() {
        return this.currentStatus == null || this.currentStatus.getCompactedStats() == null ? null : this.currentStatus.getCompactedStats();
    }

    @Nullable
    public CompactionStatistics getUncompactedStats() {
        return this.currentStatus == null || this.currentStatus.getUncompactedStats() == null ? null : this.currentStatus.getUncompactedStats();
    }

    @Nullable
    public CompactionStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public CompactionCandidate withCurrentStatus(CompactionStatus status) {
        return new CompactionCandidate(this.segments, this.umbrellaInterval, this.compactionInterval, this.numIntervals, status);
    }

    public String toString() {
        return "SegmentsToCompact{datasource=" + this.dataSource + ", segments=" + String.valueOf(SegmentUtils.commaSeparatedIdentifiers(this.segments)) + ", totalSize=" + this.totalBytes + ", currentStatus=" + String.valueOf(this.currentStatus) + "}";
    }
}

