/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import java.util.Collections;
import java.util.UUID;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;

public class ResourceIdPopulatingQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public ResourceIdPopulatingQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    public static <T> Query<T> populateResourceId(Query<T> query) {
        return query.withOverriddenContext(Collections.singletonMap("queryResourceId", UUID.randomUUID().toString()));
    }

    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        return this.baseRunner.run(queryPlus.withQuery(ResourceIdPopulatingQueryRunner.populateResourceId(queryPlus.getQuery())), responseContext);
    }
}

