/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.metrics.TaskHolder;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.metrics.LoadSpecHolder;

class LookupListeningAnnouncerConfig {
    public static final String DEFAULT_TIER = "__default";
    private final TaskHolder taskHolder;
    private final LoadSpecHolder loadSpecHolder;
    @JsonProperty(value="lookupTier")
    private String lookupTier = null;
    @JsonProperty(value="lookupTierIsDatasource")
    private boolean lookupTierIsDatasource = false;

    @JsonCreator
    public LookupListeningAnnouncerConfig(@JacksonInject TaskHolder taskHolder, @JacksonInject LoadSpecHolder loadSpecHolder) {
        this.taskHolder = taskHolder;
        this.loadSpecHolder = loadSpecHolder;
    }

    public String getLookupTier() {
        Preconditions.checkArgument((!this.lookupTierIsDatasource || null == this.lookupTier ? 1 : 0) != 0, (Object)"Cannot specify both `lookupTier` and `lookupTierIsDatasource`");
        String lookupTier = this.lookupTierIsDatasource ? this.taskHolder.getDataSource() : this.lookupTier;
        return (String)Preconditions.checkNotNull((Object)(lookupTier == null ? DEFAULT_TIER : StringUtils.emptyToNullNonDruidDataString((String)lookupTier)), (String)"Cannot have empty lookup tier from %s", (Object)(this.lookupTierIsDatasource ? "bound value" : "druid.lookup"));
    }

    public LookupLoadingSpec getLookupLoadingSpec() {
        return this.loadSpecHolder.getLookupLoadingSpec();
    }
}

