/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.JvmUtils;

public class BrokerParallelMergeConfig {
    private static final Logger LOG = new Logger(BrokerParallelMergeConfig.class);
    public static final int DEFAULT_MERGE_POOL_AWAIT_SHUTDOWN_MILLIS = 60000;
    @JsonProperty
    private final boolean useParallelMergePool;
    @JsonProperty
    private final int parallelism;
    @JsonProperty
    private final long awaitShutdownMillis;
    @JsonProperty
    private final int defaultMaxQueryParallelism;
    @JsonProperty
    private final int targetRunTimeMillis;
    @JsonProperty
    private final int initialYieldNumRows;
    @JsonProperty
    private final int smallBatchNumRows;

    @JsonCreator
    public BrokerParallelMergeConfig(@JsonProperty(value="useParallelMergePool") @Nullable Boolean useParallelMergePool, @JsonProperty(value="parallelism") @Nullable Integer parallelism, @JsonProperty(value="awaitShutdownMillis") @Nullable Long awaitShutdownMillis, @JsonProperty(value="defaultMaxQueryParallelism") @Nullable Integer defaultMaxQueryParallelism, @JsonProperty(value="targetRunTimeMillis") @Nullable Integer targetRunTimeMillis, @JsonProperty(value="initialYieldNumRows") @Nullable Integer initialYieldNumRows, @JsonProperty(value="smallBatchNumRows") @Nullable Integer smallBatchNumRows) {
        this.parallelism = Configs.valueOrDefault((Integer)parallelism, (int)((int)Math.ceil((double)JvmUtils.getRuntimeInfo().getAvailableProcessors() * 0.75)));
        if (this.parallelism > 2) {
            this.useParallelMergePool = useParallelMergePool == null || useParallelMergePool != false;
        } else {
            if (useParallelMergePool == null || useParallelMergePool.booleanValue()) {
                LOG.debug("Parallel merge pool is enabled, but there are not enough cores to enable parallel merges: %s", new Object[]{parallelism});
            }
            this.useParallelMergePool = false;
        }
        this.awaitShutdownMillis = Configs.valueOrDefault((Long)awaitShutdownMillis, (long)60000L);
        this.defaultMaxQueryParallelism = Configs.valueOrDefault((Integer)defaultMaxQueryParallelism, (int)((int)Math.max((double)JvmUtils.getRuntimeInfo().getAvailableProcessors() * 0.5, 1.0)));
        this.targetRunTimeMillis = Configs.valueOrDefault((Integer)targetRunTimeMillis, (int)100);
        this.initialYieldNumRows = Configs.valueOrDefault((Integer)initialYieldNumRows, (int)16384);
        this.smallBatchNumRows = Configs.valueOrDefault((Integer)smallBatchNumRows, (int)4096);
    }

    @VisibleForTesting
    public BrokerParallelMergeConfig() {
        this(null, null, null, null, null, null, null);
    }

    public boolean useParallelMergePool() {
        return this.useParallelMergePool;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public long getAwaitShutdownMillis() {
        return this.awaitShutdownMillis;
    }

    public int getDefaultMaxQueryParallelism() {
        return this.defaultMaxQueryParallelism;
    }

    public int getTargetRunTimeMillis() {
        return this.targetRunTimeMillis;
    }

    public int getInitialYieldNumRows() {
        return this.initialYieldNumRows;
    }

    public int getSmallBatchNumRows() {
        return this.smallBatchNumRows;
    }
}

