/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.DruidException;
import org.apache.druid.metadata.UnusedSegmentKillerConfig;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.joda.time.Period;

public class SegmentsMetadataManagerConfig {
    public static final String CONFIG_PREFIX = "druid.manager.segments";
    @JsonProperty
    private final Period pollDuration;
    @JsonProperty
    private final SegmentMetadataCache.UsageMode useIncrementalCache;
    @JsonProperty
    private final UnusedSegmentKillerConfig killUnused;

    @JsonCreator
    public SegmentsMetadataManagerConfig(@JsonProperty(value="pollDuration") Period pollDuration, @JsonProperty(value="useIncrementalCache") SegmentMetadataCache.UsageMode useIncrementalCache, @JsonProperty(value="killUnused") UnusedSegmentKillerConfig killUnused) {
        this.pollDuration = (Period)Configs.valueOrDefault((Object)pollDuration, (Object)Period.minutes((int)1));
        this.useIncrementalCache = (SegmentMetadataCache.UsageMode)((Object)Configs.valueOrDefault((Object)((Object)useIncrementalCache), (Object)((Object)SegmentMetadataCache.UsageMode.NEVER)));
        this.killUnused = (UnusedSegmentKillerConfig)Configs.valueOrDefault((Object)killUnused, (Object)new UnusedSegmentKillerConfig(null, null, null));
        if (this.killUnused.isEnabled() && this.useIncrementalCache == SegmentMetadataCache.UsageMode.NEVER) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build("Segment metadata cache must be enabled to allow killing of unused segments. Set 'druid.manager.segments.useIncrementalCache=always' or 'druid.manager.segments.useIncrementalCache=ifSynced' to enable the cache.", new Object[0]);
        }
    }

    public SegmentMetadataCache.UsageMode getCacheUsageMode() {
        return this.useIncrementalCache;
    }

    public Period getPollDuration() {
        return this.pollDuration;
    }

    public UnusedSegmentKillerConfig getKillUnused() {
        return this.killUnused;
    }
}

