/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.fasterxml.jackson.annotation.JacksonInject;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.AbstractTierSelectorStrategy;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.LowestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.PreferredTierSelectorStrategyConfig;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.timeline.DataSegment;

public class PreferredTierSelectorStrategy
extends AbstractTierSelectorStrategy {
    private static final Logger log = new Logger(PreferredTierSelectorStrategy.class);
    private final String preferredTier;
    private final TierSelectorStrategy priorityStrategy;

    public PreferredTierSelectorStrategy(@JacksonInject ServerSelectorStrategy serverSelectorStrategy, @JacksonInject PreferredTierSelectorStrategyConfig config) {
        super(serverSelectorStrategy);
        this.preferredTier = config.getTier();
        if (config.getPriority() == null) {
            this.priorityStrategy = new HighestPriorityTierSelectorStrategy(serverSelectorStrategy);
        } else if ("highest".equalsIgnoreCase(config.getPriority())) {
            this.priorityStrategy = new HighestPriorityTierSelectorStrategy(serverSelectorStrategy);
        } else if ("lowest".equalsIgnoreCase(config.getPriority())) {
            this.priorityStrategy = new LowestPriorityTierSelectorStrategy(serverSelectorStrategy);
        } else {
            throw new IAE("druid.broker.select.tier.preferred.priority must be either 'highest' or 'lowest'", new Object[0]);
        }
    }

    @Override
    public Comparator<Integer> getComparator() {
        return this.priorityStrategy.getComparator();
    }

    @Override
    public <T> List<QueryableDruidServer> pick(Query<T> query, Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment, int numServersToPick) {
        if (log.isDebugEnabled()) {
            log.debug("Picking [%d] servers from preferred tier [%s] for segment [%s] with priority [%s]", new Object[]{numServersToPick, this.preferredTier, segment.getId(), this.priorityStrategy.getClass().getSimpleName()});
        }
        Int2ObjectRBTreeMap preferred = new Int2ObjectRBTreeMap(this.priorityStrategy.getComparator());
        Int2ObjectRBTreeMap nonPreferred = new Int2ObjectRBTreeMap(this.priorityStrategy.getComparator());
        for (Set priorityServers : prioritizedServers.values()) {
            for (QueryableDruidServer server : priorityServers) {
                if (this.preferredTier.equals(server.getServer().getMetadata().getTier())) {
                    ((Set)preferred.computeIfAbsent(server.getServer().getPriority(), k -> new HashSet())).add(server);
                    continue;
                }
                ((Set)nonPreferred.computeIfAbsent(server.getServer().getPriority(), k -> new HashSet())).add(server);
            }
        }
        ArrayList<QueryableDruidServer> picks = new ArrayList<QueryableDruidServer>(numServersToPick);
        if (!preferred.isEmpty()) {
            picks.addAll(this.priorityStrategy.pick(query, (Int2ObjectRBTreeMap<Set<QueryableDruidServer>>)preferred, segment, numServersToPick));
        }
        if (picks.size() < numServersToPick && !nonPreferred.isEmpty()) {
            int remaining = numServersToPick - picks.size();
            picks.addAll(this.priorityStrategy.pick(query, (Int2ObjectRBTreeMap<Set<QueryableDruidServer>>)nonPreferred, segment, remaining));
        }
        return picks;
    }
}

