/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.coordinator;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.BootstrapSegmentsResponse;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.joda.time.Interval;

public interface CoordinatorClient {
    public ListenableFuture<Boolean> isHandoffComplete(String var1, SegmentDescriptor var2);

    public ListenableFuture<DataSegment> fetchSegment(String var1, String var2, boolean var3);

    public Iterable<ImmutableSegmentLoadInfo> fetchServerViewSegments(String var1, List<Interval> var2);

    public ListenableFuture<List<DataSegment>> fetchUsedSegments(String var1, List<Interval> var2);

    public ListenableFuture<List<DataSourceInformation>> fetchDataSourceInformation(Set<String> var1);

    public ListenableFuture<BootstrapSegmentsResponse> fetchBootstrapSegments();

    public CoordinatorClient withRetryPolicy(ServiceRetryPolicy var1);

    public ListenableFuture<Set<String>> fetchDataSourcesWithUsedSegments();

    public ListenableFuture<CompactionStatusResponse> getCompactionSnapshots(@Nullable String var1);

    public ListenableFuture<CoordinatorDynamicConfig> getCoordinatorDynamicConfig();

    public ListenableFuture<Void> updateCoordinatorDynamicConfig(CoordinatorDynamicConfig var1);

    public ListenableFuture<Void> updateAllLookups(Object var1);

    public Map<String, LookupExtractorFactoryContainer> fetchLookupsForTierSync(String var1);

    public ListenableFuture<CloseableIterator<SegmentStatusInCluster>> fetchAllUsedSegmentsWithOvershadowedStatus(@Nullable Set<String> var1, boolean var2);

    public ListenableFuture<Map<String, List<Rule>>> getRulesForAllDatasources();

    public ListenableFuture<URI> findCurrentLeader();

    public ListenableFuture<Void> updateRulesForDatasource(String var1, List<Rule> var2);
}

