/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CollectionUtils;

public class ImmutableDruidServer {
    private final DruidServerMetadata metadata;
    private final long currSize;
    private final ImmutableMap<String, ImmutableDruidDataSource> dataSources;
    private final int numSegments;

    public ImmutableDruidServer(DruidServerMetadata metadata, long currSize, ImmutableMap<String, ImmutableDruidDataSource> dataSources, int numSegments) {
        this.metadata = (DruidServerMetadata)Preconditions.checkNotNull((Object)metadata);
        this.currSize = currSize;
        this.dataSources = dataSources;
        this.numSegments = numSegments;
    }

    public String getName() {
        return this.metadata.getName();
    }

    public DruidServerMetadata getMetadata() {
        return this.metadata;
    }

    public String getHost() {
        return this.metadata.getHost();
    }

    public String getHostAndPort() {
        return this.metadata.getHostAndPort();
    }

    public String getHostAndTlsPort() {
        return this.metadata.getHostAndTlsPort();
    }

    public long getCurrSize() {
        return this.currSize;
    }

    public long getMaxSize() {
        return this.metadata.getMaxSize();
    }

    public ServerType getType() {
        return this.metadata.getType();
    }

    public String getTier() {
        return this.metadata.getTier();
    }

    public int getPriority() {
        return this.metadata.getPriority();
    }

    @Nullable
    public DataSegment getSegment(SegmentId segmentId) {
        ImmutableDruidDataSource dataSource = (ImmutableDruidDataSource)this.dataSources.get((Object)segmentId.getDataSource());
        if (dataSource == null) {
            return null;
        }
        return dataSource.getSegment(segmentId);
    }

    public Iterable<ImmutableDruidDataSource> getDataSources() {
        return this.dataSources.values();
    }

    public ImmutableDruidDataSource getDataSource(String name) {
        return (ImmutableDruidDataSource)this.dataSources.get((Object)name);
    }

    public Collection<DataSegment> iterateAllSegments() {
        return CollectionUtils.createLazyCollectionFromStream(() -> this.dataSources.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()), (int)this.numSegments);
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public String getURL() {
        if (this.metadata.getHostAndTlsPort() != null) {
            return StringUtils.nonStrictFormat((String)"https://%s", (Object[])new Object[]{this.metadata.getHostAndTlsPort()});
        }
        return StringUtils.nonStrictFormat((String)"http://%s", (Object[])new Object[]{this.metadata.getHostAndPort()});
    }

    public String toString() {
        return "ImmutableDruidServer{meta='" + String.valueOf(this.metadata) + "', size='" + this.currSize + "', sources='" + String.valueOf(this.dataSources) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableDruidServer that = (ImmutableDruidServer)o;
        return this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }
}

