/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.server.coordinator.CatalogDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Period;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=InlineSchemaDataSourceCompactionConfig.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="inline", value=InlineSchemaDataSourceCompactionConfig.class), @JsonSubTypes.Type(name="catalog", value=CatalogDataSourceCompactionConfig.class)})
public interface DataSourceCompactionConfig {
    public static final int DEFAULT_COMPACTION_TASK_PRIORITY = 25;
    public static final long DEFAULT_INPUT_SEGMENT_SIZE_BYTES = 100000000000000L;
    public static final Period DEFAULT_SKIP_OFFSET_FROM_LATEST = new Period((Object)"P1D");

    public String getDataSource();

    @Nullable
    public CompactionEngine getEngine();

    public int getTaskPriority();

    public long getInputSegmentSizeBytes();

    @Deprecated
    @Nullable
    public Integer getMaxRowsPerSegment();

    public Period getSkipOffsetFromLatest();

    @Nullable
    public UserCompactionTaskQueryTuningConfig getTuningConfig();

    @Nullable
    public UserCompactionTaskIOConfig getIoConfig();

    @Nullable
    public Map<String, Object> getTaskContext();

    @Nullable
    public Granularity getSegmentGranularity();

    @Nullable
    public UserCompactionTaskGranularityConfig getGranularitySpec();

    @Nullable
    public List<AggregateProjectionSpec> getProjections();

    @Nullable
    public CompactionTransformSpec getTransformSpec();

    @Nullable
    public UserCompactionTaskDimensionsConfig getDimensionsSpec();

    @Nullable
    public AggregatorFactory[] getMetricsSpec();
}

