/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.JettyUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.proxy.ProxyServlet;

public class OverlordProxyServlet
extends ProxyServlet {
    private final OverlordClient overlordClient;
    private final Provider<HttpClient> httpClientProvider;
    private final DruidHttpClientConfig httpClientConfig;

    @Inject
    OverlordProxyServlet(OverlordClient overlordClient, @Global Provider<HttpClient> httpClientProvider, @Global DruidHttpClientConfig httpClientConfig) {
        this.overlordClient = overlordClient;
        this.httpClientProvider = httpClientProvider;
        this.httpClientConfig = httpClientConfig;
    }

    protected String rewriteTarget(HttpServletRequest request) {
        String overlordLeader = ((URI)FutureUtils.getUnchecked(this.overlordClient.findCurrentLeader(), (boolean)true)).toString();
        return JettyUtils.concatenateForRewrite(overlordLeader, request.getRequestURI(), request.getQueryString());
    }

    protected HttpClient newHttpClient() {
        return (HttpClient)this.httpClientProvider.get();
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        this.setTimeout(this.httpClientConfig.getReadTimeout().getMillis());
        return client;
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        clientRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
    }
}

