/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.server.coordination.SegmentBootstrapper;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/historical/v1")
public class HistoricalResource {
    private final SegmentBootstrapper segmentBootstrapper;

    @Inject
    public HistoricalResource(SegmentBootstrapper segmentBootstrapper) {
        this.segmentBootstrapper = segmentBootstrapper;
    }

    @GET
    @Path(value="/loadstatus")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLoadStatus() {
        return Response.ok((Object)ImmutableMap.of((Object)"cacheInitialized", (Object)this.segmentBootstrapper.isBootstrappingComplete())).build();
    }

    @GET
    @Path(value="/readiness")
    public Response getReadiness() {
        if (this.segmentBootstrapper.isBootstrappingComplete()) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }
}

