/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.timeline.DataSegment;

public class DiskNormalizedCostBalancerStrategy
extends CostBalancerStrategy {
    public DiskNormalizedCostBalancerStrategy(ListeningExecutorService exec) {
        super(exec);
    }

    @Override
    protected double computePlacementCost(DataSegment proposalSegment, ServerHolder server) {
        double cost = super.computePlacementCost(proposalSegment, server);
        if (cost == Double.POSITIVE_INFINITY) {
            return cost;
        }
        int nSegments = 1;
        if (server.getServer().getNumSegments() > 0) {
            nSegments = server.getServer().getNumSegments();
        }
        double normalizedCost = cost / (double)nSegments;
        double usageRatio = (double)server.getSizeUsed() / (double)server.getServer().getMaxSize();
        return normalizedCost * usageRatio;
    }
}

