/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.client.CachingQueryRunner;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.PerSegmentOptimizingQueryRunner;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.server.ResourceIdPopulatingQueryRunner;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.utils.CloseableUtils;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final QueryProcessingPool queryProcessingPool;
    private final CachePopulator cachePopulator;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    private final SegmentManager segmentManager;
    private final ServerConfig serverConfig;
    private final PolicyEnforcer policyEnforcer;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig, PolicyEnforcer policyEnforcer) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.queryProcessingPool = queryProcessingPool;
        this.cachePopulator = cachePopulator;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.serverConfig = serverConfig;
        this.policyEnforcer = policyEnforcer;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        Optional<VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider>> maybeTimeline = this.segmentManager.getTimeline(ExecutionVertex.of(query).getBaseTableDataSource());
        if (!maybeTimeline.isPresent()) {
            return new NoopQueryRunner();
        }
        VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline = maybeTimeline.get();
        FunctionalIterable segmentDescriptors = FunctionalIterable.create(intervals).transformCat(arg_0 -> timeline.lookup(arg_0)).transformCat(holder -> {
            if (holder == null) {
                return null;
            }
            return FunctionalIterable.create((Iterable)holder.getObject()).transform(partitionChunk -> new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), partitionChunk.getChunkNumber()));
        });
        return this.getQueryRunnerForSegments(query, (Iterable<SegmentDescriptor>)segmentDescriptors);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        ExecutionVertex ev = ExecutionVertex.of(query);
        Optional<VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider>> maybeTimeline = this.segmentManager.getTimeline(ev.getBaseTableDataSource());
        if (maybeTimeline.isEmpty()) {
            return new ReportTimelineMissingSegmentQueryRunner((List)Lists.newArrayList(specs));
        }
        QueryRunnerFactory<T, Query<T>> factory = this.getQueryRunnerFactory(query);
        QueryToolChest<T, Query<T>> toolChest = ServerManager.getQueryToolChest(query, factory);
        VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline = maybeTimeline.get();
        return new ResourceManagingQueryRunner<T>(timeline, factory, toolChest, ev, specs);
    }

    protected List<SegmentReference> acquireAllSegments(VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline, Iterable<SegmentDescriptor> segments, SegmentMapFunction segmentMapFn, Closer closer) {
        return Lists.newArrayList((Iterable)FunctionalIterable.create(segments).transform(descriptor -> {
            PartitionChunk chunk = timeline.findChunk(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getPartitionNumber());
            if (chunk == null) {
                return new SegmentReference((SegmentDescriptor)descriptor, Optional.empty());
            }
            ReferenceCountedSegmentProvider referenceCounter = (ReferenceCountedSegmentProvider)chunk.getObject();
            return new SegmentReference((SegmentDescriptor)descriptor, ((Optional)segmentMapFn.apply((Object)referenceCounter)).map(arg_0 -> ((Closer)closer).register(arg_0)));
        }));
    }

    protected <T> FunctionalIterable<QueryRunner<T>> getQueryRunnersForSegments(VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline, Iterable<SegmentDescriptor> specs, Query<T> query, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, SegmentMapFunction segmentMapFn, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix, Closer closer) {
        return FunctionalIterable.create(this.acquireAllSegments(timeline, specs, segmentMapFn, closer)).transform(ref -> ref.getSegmentReference().map(segment -> this.buildQueryRunnerForSegment(ref.getSegmentDescriptor(), (Segment)segment, factory, toolChest, cpuTimeAccumulator, cacheKeyPrefix)).orElse((QueryRunner)new ReportTimelineMissingSegmentQueryRunner(ref.getSegmentDescriptor())));
    }

    protected <T> QueryRunner<T> buildQueryRunnerForSegment(SegmentDescriptor segmentDescriptor, Segment segment, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix) {
        if (segment.isTombstone()) {
            return new NoopQueryRunner();
        }
        SegmentId segmentId = segment.getId();
        Interval segmentInterval = segment.getDataInterval();
        String segmentIdString = segmentId.toString();
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerInner = new MetricsEmittingQueryRunner(this.emitter, toolChest, factory.createRunner(segment), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentIdString));
        TimeBoundaryInspector timeBoundaryInspector = (TimeBoundaryInspector)segment.as(TimeBoundaryInspector.class);
        Interval cacheKeyInterval = timeBoundaryInspector != null ? timeBoundaryInspector.getMinMaxInterval() : segmentInterval;
        CachingQueryRunner cachingQueryRunner = new CachingQueryRunner(segmentIdString, cacheKeyPrefix, segmentDescriptor, cacheKeyInterval, this.objectMapper, this.cache, (QueryToolChest)toolChest, metricsEmittingQueryRunnerInner, this.cachePopulator, this.cacheConfig);
        BySegmentQueryRunner bySegmentQueryRunner = new BySegmentQueryRunner(segmentId, segmentInterval.getStart(), cachingQueryRunner);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerOuter = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)bySegmentQueryRunner, QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentIdString)).withWaitMeasuredFromNow();
        SpecificSegmentQueryRunner specificSegmentQueryRunner = new SpecificSegmentQueryRunner((QueryRunner)metricsEmittingQueryRunnerOuter, segmentSpec);
        PerSegmentOptimizingQueryRunner perSegmentOptimizingQueryRunner = new PerSegmentOptimizingQueryRunner((QueryRunner)specificSegmentQueryRunner, new PerSegmentQueryOptimizationContext(segmentDescriptor));
        return new SetAndVerifyContextQueryRunner(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild((QueryRunner)perSegmentOptimizingQueryRunner, toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false));
    }

    private <T> QueryRunnerFactory<T, Query<T>> getQueryRunnerFactory(Query<T> query) {
        DataSource dataSourceFromQuery = query.getDataSource();
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            QueryUnsupportedException e = new QueryUnsupportedException(StringUtils.format((String)"Unknown query type, [%s]", (Object[])new Object[]{query.getClass()}));
            log.makeAlert((Throwable)e, "Error while executing a query[%s]", new Object[]{query.getId()}).addData("dataSource", (Object)dataSourceFromQuery).emit();
            throw e;
        }
        return factory;
    }

    private static <T> QueryToolChest<T, Query<T>> getQueryToolChest(Query<T> query, QueryRunnerFactory<T, Query<T>> factory) {
        DataSource dataSourceFromQuery = query.getDataSource();
        QueryToolChest toolChest = factory.getToolchest();
        if (dataSourceFromQuery instanceof QueryDataSource && !toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery())) {
            throw new QueryUnsupportedException(StringUtils.format((String)"Cannot handle subquery: %s", (Object[])new Object[]{dataSourceFromQuery}));
        }
        return toolChest;
    }

    public final class ResourceManagingQueryRunner<T>
    implements QueryRunner<T> {
        private final VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline;
        private final QueryRunnerFactory<T, Query<T>> factory;
        private final QueryToolChest<T, Query<T>> toolChest;
        private final ExecutionVertex ev;
        private final Iterable<SegmentDescriptor> specs;

        public ResourceManagingQueryRunner(VersionedIntervalTimeline<String, ReferenceCountedSegmentProvider> timeline, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, ExecutionVertex ev, Iterable<SegmentDescriptor> specs) {
            this.timeline = timeline;
            this.factory = factory;
            this.toolChest = toolChest;
            this.ev = ev;
            this.specs = specs;
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            queryPlus = queryPlus.withQuery(ResourceIdPopulatingQueryRunner.populateResourceId(queryPlus.getQuery()));
            Query query = queryPlus.getQuery();
            AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
            SegmentMapFunction segmentMapFn = (SegmentMapFunction)JvmUtils.safeAccumulateThreadCpuTime((AtomicLong)cpuTimeAccumulator, () -> this.ev.createSegmentMapFunction(ServerManager.this.policyEnforcer));
            Optional<byte[]> cacheKeyPrefix = Optional.ofNullable(query.getDataSource().getCacheKey());
            Closer closer = Closer.create();
            try {
                FunctionalIterable<QueryRunner<T>> queryRunners = ServerManager.this.getQueryRunnersForSegments(this.timeline, this.specs, query, this.factory, this.toolChest, segmentMapFn, cpuTimeAccumulator, cacheKeyPrefix, closer);
                QueryRunner queryRunner = CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(this.toolChest.mergeResults(this.factory.mergeRunners(ServerManager.this.queryProcessingPool, queryRunners), true), this.toolChest), this.toolChest, (ServiceEmitter)ServerManager.this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
                return queryRunner.run(queryPlus, responseContext).withBaggage((Closeable)closer);
            }
            catch (Throwable t) {
                throw CloseableUtils.closeAndWrapInCatch((Throwable)t, (Closeable)closer);
            }
        }
    }

    public static final class SegmentReference {
        private final SegmentDescriptor segmentDescriptor;
        private final Optional<Segment> segmentReference;

        public SegmentReference(SegmentDescriptor segmentDescriptor, Optional<Segment> segmentReference) {
            this.segmentDescriptor = segmentDescriptor;
            this.segmentReference = segmentReference;
        }

        public SegmentDescriptor getSegmentDescriptor() {
            return this.segmentDescriptor;
        }

        public Optional<Segment> getSegmentReference() {
            return this.segmentReference;
        }
    }
}

