/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public class OmniDataSegmentKiller
implements DataSegmentKiller {
    private final Map<String, Supplier<DataSegmentKiller>> killers = new HashMap<String, Supplier<DataSegmentKiller>>();

    @Inject
    public OmniDataSegmentKiller(Map<String, Provider<DataSegmentKiller>> killers) {
        for (Map.Entry<String, Provider<DataSegmentKiller>> entry : killers.entrySet()) {
            String type = entry.getKey();
            Provider<DataSegmentKiller> provider = entry.getValue();
            this.killers.put(type, (Supplier<DataSegmentKiller>)Suppliers.memoize(() -> provider.get()));
        }
    }

    public void kill(List<DataSegment> segments) throws SegmentLoadingException {
        HashMap<DataSegmentKiller, List> killersToSegments = new HashMap<DataSegmentKiller, List>();
        for (DataSegment dataSegment : segments) {
            DataSegmentKiller dataSegmentKiller = this.getKiller(dataSegment);
            if (dataSegmentKiller == null) continue;
            List segmentsList = killersToSegments.computeIfAbsent(dataSegmentKiller, x -> new ArrayList());
            segmentsList.add(dataSegment);
        }
        for (Map.Entry entry : killersToSegments.entrySet()) {
            ((DataSegmentKiller)entry.getKey()).kill((List)entry.getValue());
        }
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        DataSegmentKiller dataSegmentKiller = this.getKiller(segment);
        if (dataSegmentKiller != null) {
            dataSegmentKiller.kill(segment);
        }
    }

    @Nullable
    private DataSegmentKiller getKiller(DataSegment segment) throws SegmentLoadingException {
        if (segment.isTombstone()) {
            return null;
        }
        String type = MapUtils.getString((Map)segment.getLoadSpec(), (String)"type");
        Supplier<DataSegmentKiller> killer = this.killers.get(type);
        if (killer == null) {
            throw new SegmentLoadingException("Unknown segment killer type[%s].  Known types are %s", new Object[]{type, this.killers.keySet()});
        }
        return (DataSegmentKiller)killer.get();
    }

    public void killAll() {
        throw new UnsupportedOperationException("not implemented");
    }

    @VisibleForTesting
    public Map<String, Supplier<DataSegmentKiller>> getKillers() {
        return this.killers;
    }
}

