/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.druid.sql.hook.DruidHook;
import org.apache.druid.sql.hook.DruidHookDispatcher;

public class QuidemRecorder
implements AutoCloseable,
DruidHook<String> {
    private PrintStream printStream;
    private File file;
    private DruidHookDispatcher hookDispatcher;
    private Set<String> queries = new HashSet<String>();

    public QuidemRecorder(URI quidemURI, DruidHookDispatcher hookDispatcher, File file) {
        this.hookDispatcher = hookDispatcher;
        this.file = file;
        try {
            this.printStream = new PrintStream((OutputStream)new FileOutputStream(file), true, StandardCharsets.UTF_8.name());
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.printStream.println("#started " + String.valueOf(new Date()));
        this.printStream.println("!use " + String.valueOf(quidemURI));
        this.printStream.println("!set outputformat mysql");
        hookDispatcher.register(DruidHook.SQL, (DruidHook)this);
    }

    @Override
    public synchronized void close() {
        if (this.printStream != null) {
            this.printStream.close();
            this.printStream = null;
        }
        this.hookDispatcher.unregister(DruidHook.SQL, (DruidHook)this);
    }

    public synchronized void invoke(DruidHook.HookKey<String> key, String query) {
        if (DruidHook.SQL.equals(key)) {
            if (this.queries.contains(query)) {
                return;
            }
            this.printStream.println("# " + String.valueOf(new Date()));
            this.printStream.print(query);
            this.printStream.println(";");
            this.printStream.println("!ok");
            this.printStream.flush();
            this.queries.add(query);
            return;
        }
    }

    public String toString() {
        return "QuidemRecorder [file=" + String.valueOf(this.file) + "]";
    }
}

