/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.quidem.ProjectPathUtils;
import org.apache.druid.quidem.QuidemRecorder;
import org.apache.druid.sql.hook.DruidHookDispatcher;

@Path(value="/quidem")
@LazySingleton
public class QuidemCaptureResource {
    public static final File RECORD_PATH = ProjectPathUtils.getPathFromProjectRoot((String)"quidem-ut/src/test/quidem/org.apache.druid.quidem.QTest");
    private URI quidemURI;
    private QuidemRecorder recorder = null;
    private DruidHookDispatcher hookDispatcher;

    @Inject
    public QuidemCaptureResource(@Named(value="quidem") URI quidemURI, DruidHookDispatcher hookDispatcher) {
        this.quidemURI = quidemURI;
        this.hookDispatcher = hookDispatcher;
    }

    @GET
    @Path(value="/start")
    @Produces(value={"text/plain"})
    public synchronized String start() {
        this.stopIfRunning();
        this.recorder = new QuidemRecorder(this.quidemURI, this.hookDispatcher, this.genRecordFilePath());
        return this.recorder.toString();
    }

    private File genRecordFilePath() {
        String fileName = StringUtils.format((String)"record-%d.iq", (Object[])new Object[]{System.currentTimeMillis()});
        return new File(RECORD_PATH, fileName);
    }

    private synchronized void stopIfRunning() {
        if (this.recorder != null) {
            this.recorder.close();
            this.recorder = null;
        }
    }
}

