/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.quidem.ExposedAsBrokerQueryComponentSupplierWrapper;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Launcher {
    static final SqlTestFrameworkConfig.SqlTestFrameworkConfigStore CONFIG_STORE = new SqlTestFrameworkConfig.SqlTestFrameworkConfigStore(x -> new ExposedAsBrokerQueryComponentSupplierWrapper((SqlTestFramework.QueryComponentSupplier)x));
    private static final String QUIDEM_URI = "quidem.uri";
    private static Logger log = new Logger(Launcher.class);
    private final SqlTestFramework framework;
    private final SqlTestFrameworkConfig.ConfigurationInstance configurationInstance;
    private Lifecycle lifecycle;

    public Launcher(String uri) throws Exception {
        SqlTestFrameworkConfig config = SqlTestFrameworkConfig.fromURL((String)uri);
        this.configurationInstance = CONFIG_STORE.getConfigurationInstance(config);
        this.framework = this.configurationInstance.framework;
    }

    public void start() throws Exception {
        this.lifecycle = GuiceRunnable.initLifecycle((Injector)this.framework.injector(), (Logger)log);
        if (this.withAutoStart()) {
            this.callQuidemStart();
        }
    }

    private void callQuidemStart() throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet request = new HttpGet("http://localhost:12345/quidem/start");
        request.addHeader("Content-Type", "application/json");
        client.execute((HttpUriRequest)request);
    }

    private boolean withAutoStart() {
        return Boolean.valueOf(System.getProperty("quidem.record.autostart", "false"));
    }

    public void shutdown() {
        this.lifecycle.stop();
    }

    public static void main(String[] args) throws Exception {
        String quidemUri = System.getProperty(QUIDEM_URI, "druidtest:///");
        Properties p = System.getProperties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            Object key = entry.getKey();
            if (!key.toString().startsWith("quidem")) continue;
            log.info("[%s] -> %s", new Object[]{key, entry.getValue()});
        }
        log.info("Starting Quidem with URI[%s]", new Object[]{quidemUri});
        Stopwatch stopwatch = Stopwatch.createStarted();
        Launcher launcher = new Launcher(quidemUri);
        log.info("Framework creation time: %d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        launcher.start();
        log.info("Total time to launch: %d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        launcher.lifecycle.join();
    }
}

