/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.ResourceInputSource;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;

public class KttmNestedComponentSupplier
extends SqlTestFramework.StandardComponentSupplier {
    public KttmNestedComponentSupplier(TempDirProducer tempDirProducer) {
        super(tempDirProducer);
    }

    public SpecificSegmentsQuerySegmentWalker addSegmentsToWalker(SpecificSegmentsQuerySegmentWalker walker) {
        walker = super.addSegmentsToWalker(walker);
        QueryableIndex idx = this.makeKttmIndex(this.tempDirProducer.newTempFolder());
        walker.add(DataSegment.builder().dataSource("kttm_nested").interval(Intervals.of((String)"2019-08-25/2019-08-26")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 0)).size(0L).build(), idx);
        return walker;
    }

    public QueryableIndex makeKttmIndex(File tmpDir) {
        try {
            File directory = new File(tmpDir, StringUtils.format((String)"kttm-index-%s", (Object[])new Object[]{UUID.randomUUID()}));
            IncrementalIndex index = this.makeKttmNestedIndex();
            TestIndex.INDEX_MERGER.persist(index, directory, IndexSpec.DEFAULT, null);
            return TestIndex.INDEX_IO.loadIndex(directory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalIndex makeKttmNestedIndex() {
        IncrementalIndex incrementalIndex;
        List<DimensionSchema> dimensions = Arrays.asList(new StringDimensionSchema("session"), new StringDimensionSchema("number"), new AutoTypeColumnSchema("event", null), new AutoTypeColumnSchema("agent", null), new StringDimensionSchema("client_ip"), new StringDimensionSchema("geo_ip"), new StringDimensionSchema("language"), new StringDimensionSchema("adblock_list"), new StringDimensionSchema("app_version"), new StringDimensionSchema("path"), new StringDimensionSchema("loaded_image"), new StringDimensionSchema("referrer"), new StringDimensionSchema("referrer_host"), new StringDimensionSchema("server_ip"), new StringDimensionSchema("screen"), new StringDimensionSchema("window"), new LongDimensionSchema("session_length"), new StringDimensionSchema("timezone"), new LongDimensionSchema("timezone_offset"));
        File tmpDir = FileUtils.createTempDir((String)"test-index-input-source");
        try {
            ResourceInputSource inputSource = ResourceInputSource.of((ClassLoader)TestIndex.class.getClassLoader(), (String)"kttm-nested-v2-2019-08-25.json");
            incrementalIndex = IndexBuilder.create().segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withRollup(false).withTimestampSpec(new TimestampSpec("timestamp", null, null)).withDimensionsSpec(new DimensionsSpec(dimensions)).build()).inputSource((InputSource)inputSource).inputFormat((InputFormat)TestIndex.DEFAULT_JSON_INPUT_FORMAT).inputTmpDir(new File(tmpDir, "tmpKttm")).buildIncrementalIndex();
        }
        catch (Throwable throwable) {
            try {
                FileUtils.deleteDirectory((File)tmpDir);
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileUtils.deleteDirectory((File)tmpDir);
        return incrementalIndex;
    }
}

